/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory;

import com.dynatrace.android.instrumentation.filter.ClassLevelFilter;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.ReplaceInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.sensor.method.StartMethodTransformation;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpTransformerFactory
implements TransformerFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)"OkHttpTransformerFactory");
    private static final String CALL = "okhttp3.Call";
    private static final String CALLBACK = "okhttp3.Callback";
    private static final String CLIENT = "okhttp3.OkHttpClient";
    private static final String RESPONSE = "okhttp3.Response";
    private static final String CLIENT_BUILDER = "okhttp3.OkHttpClient$Builder";
    private static final String IOEXCEPTION = "java.io.IOException";
    private static final String OK_URL_FACTORY = "okhttp3.OkUrlFactory";

    @Override
    public SubTransformer generateTransformer(ClassLoader classLoader, boolean warningsAsErrors) throws Exception {
        try {
            ArrayList<SensorGroup<MethodSensor>> methodSensors = new ArrayList<SensorGroup<MethodSensor>>();
            methodSensors.add(this.generateCallbackSensors(classLoader));
            methodSensors.add(this.generateOkHttpClientSensors(classLoader));
            ArrayList<SensorGroup<InstructionSensor>> instructionSensors = new ArrayList<SensorGroup<InstructionSensor>>();
            instructionSensors.add(this.generateCallSensors(classLoader));
            return new DefaultSubTransformer("OkHttp3Transformer", instructionSensors, methodSensors, classLoader, warningsAsErrors);
        }
        catch (ClassNotFoundException e) {
            logger.debug("Deactivate instrumentation for OkHttp3 web requests, because it is not part of the classpath");
            return null;
        }
    }

    @Override
    public List<String> mandatoryClasses() {
        return Collections.singletonList(CLIENT);
    }

    @Override
    public List<ClassLevelFilter> excludeClassFiles() {
        return Collections.singletonList(className -> className.startsWith("okhttp3.") && !className.startsWith(OK_URL_FACTORY));
    }

    private SensorGroup<InstructionSensor> generateCallSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> okhttpCallback = Class.forName(CALLBACK, false, classLoader);
        Class<?> call = Class.forName(CALL, false, classLoader);
        Method execute = call.getDeclaredMethod("execute", new Class[0]);
        Method enqueue = call.getDeclaredMethod("enqueue", okhttpCallback);
        Class<?> callback = Class.forName("com.dynatrace.android.callback.OkCallback", false, classLoader);
        Method instr_execute = callback.getDeclaredMethod("execute", call);
        Method instr_enqueue = callback.getDeclaredMethod("enqueue", call, okhttpCallback);
        return new SensorGroupImpl<InstructionSensor>(call, new ReplaceInstructionSensor(execute, instr_execute), new ReplaceInstructionSensor(enqueue, instr_enqueue));
    }

    private SensorGroup<MethodSensor> generateCallbackSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> call = Class.forName(CALL, false, classLoader);
        Class<?> response = Class.forName(RESPONSE, false, classLoader);
        Class<?> ioException = Class.forName(IOEXCEPTION, false, classLoader);
        Class<?> okhttpCallback = Class.forName(CALLBACK, false, classLoader);
        Method onResponse = okhttpCallback.getDeclaredMethod("onResponse", call, response);
        Method onFailure = okhttpCallback.getDeclaredMethod("onFailure", call, ioException);
        Class<?> callback = Class.forName("com.dynatrace.android.callback.OkCallback", false, classLoader);
        Method instr_onResponse_ENTER = callback.getDeclaredMethod("onResponse_ENTER", call, response);
        Method instr_onResponse_EXIT = callback.getDeclaredMethod("onResponse_EXIT", new Class[0]);
        Method instr_onFailure_ENTER = callback.getDeclaredMethod("onFailure_ENTER", call, ioException);
        Method instr_onFailure_EXIT = callback.getDeclaredMethod("onFailure_EXIT", new Class[0]);
        return new SensorGroupImpl<MethodSensor>(okhttpCallback, new MethodSensorImpl(onResponse, MethodSensorImpl.generateDefaultMethodTransformer(instr_onResponse_ENTER, instr_onResponse_EXIT)), new MethodSensorImpl(onFailure, MethodSensorImpl.generateDefaultMethodTransformer(instr_onFailure_ENTER, instr_onFailure_EXIT)));
    }

    private SensorGroup<MethodSensor> generateOkHttpClientSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> builder = Class.forName(CLIENT_BUILDER, false, classLoader);
        Class<?> client = Class.forName(CLIENT, false, classLoader);
        Constructor<?> constructor = client.getDeclaredConstructor(builder);
        Class<?> callback = Class.forName("com.dynatrace.android.callback.OkCallback", false, classLoader);
        Method instr_newInstance = callback.getDeclaredMethod("newInstance_START", builder);
        return new SensorGroupImpl<MethodSensor>(clazz -> clazz == client, new MethodSensorImpl(constructor, new StartMethodTransformation(instr_newInstance, ParameterInstructionProvider.withAllParameters(constructor))));
    }
}

