/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory;

import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.ExitMethodTransformation;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.sensor.method.StartMethodTransformation;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserActionTransformerFactory
implements TransformerFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)"UserActionTransformerFactory");
    private static final String ON_CLICK_LISTENER = "android.view.View$OnClickListener";
    private static final String ON_ITEM_CLICK_LISTENER = "android.widget.AdapterView$OnItemClickListener";
    private static final String ON_ITEM_SELECTED_LISTENER = "android.widget.AdapterView$OnItemSelectedListener";
    private static final String ON_MENU_ITEM_CLICK_LISTENER = "android.view.MenuItem$OnMenuItemClickListener";
    private static final String ON_PAGE_CHANGE_LISTENER_SUPPORT = "android.support.v4.view.ViewPager$OnPageChangeListener";
    private static final String ON_REFRESH_LISTENER_SUPPORT = "android.support.v4.widget.SwipeRefreshLayout$OnRefreshListener";
    private static final String ON_PAGE_CHANGE_LISTENER_ANDROID_X = "androidx.viewpager.widget.ViewPager$OnPageChangeListener";
    private static final String ON_REFRESH_LISTENER_ANDROID_X = "androidx.swiperefreshlayout.widget.SwipeRefreshLayout$OnRefreshListener";
    private static final String VIEW = "android.view.View";
    private static final String ADAPTER_VIEW = "android.widget.AdapterView";
    private static final String MENU_ITEM = "android.view.MenuItem";
    private static final String ACTIVITY = "android.app.Activity";
    private Sensors sensors;

    public UserActionTransformerFactory(Sensors sensors) {
        this.sensors = sensors;
    }

    private static ParameterInstructionProvider generateAdapterViewParameters() {
        return ParameterInstructionProvider.withCustomParameter(25, 1).andThen(ParameterInstructionProvider.withCustomParameter(21, 2));
    }

    private static List<MethodTransformation> generateAdapterViewMethodSensor(Method startSensorMethod, Method exitSensorMethod) {
        return Arrays.asList(new ExitMethodTransformation(exitSensorMethod, null), new StartMethodTransformation(startSensorMethod, UserActionTransformerFactory.generateAdapterViewParameters()));
    }

    @Override
    public SubTransformer generateTransformer(ClassLoader classLoader, boolean warningsAsErrors) throws Exception {
        ArrayList<SensorGroup<MethodSensor>> methodSensors = new ArrayList<SensorGroup<MethodSensor>>();
        if (this.sensors.onClickListener) {
            methodSensors.add(this.generateOnClickListenerSensors(classLoader));
        }
        if (this.sensors.onItemClickListener) {
            methodSensors.add(this.generateOnItemClickListenerSensors(classLoader));
        }
        if (this.sensors.onItemSelectedListener) {
            methodSensors.add(this.generateOnItemSelectedListenerSensors(classLoader));
        }
        if (this.sensors.onMenuItemClickListener) {
            methodSensors.add(this.generateOnMenuItemClickListenerSensors(classLoader));
        }
        if (this.sensors.onOptionsItemSelected) {
            methodSensors.add(this.generateActivitySensors(classLoader));
        }
        if (this.sensors.onPageChangeListener) {
            try {
                methodSensors.add(this.generateOnPageChangeListenerAndroidXSensors(classLoader));
            }
            catch (ClassNotFoundException e) {
                logger.debug("Deactivate instrumentation for class {}", (Object)ON_PAGE_CHANGE_LISTENER_ANDROID_X);
            }
            try {
                methodSensors.add(this.generateOnPageChangeListenerSupportSensors(classLoader));
            }
            catch (ClassNotFoundException e) {
                logger.debug("Deactivate instrumentation for class {}", (Object)ON_PAGE_CHANGE_LISTENER_SUPPORT);
            }
        }
        if (this.sensors.onRefreshListener) {
            try {
                methodSensors.add(this.generateOnRefreshListenerAndroidXSensors(classLoader));
            }
            catch (ClassNotFoundException e) {
                logger.debug("Deactivate instrumentation for class {}", (Object)ON_REFRESH_LISTENER_ANDROID_X);
            }
            try {
                methodSensors.add(this.generateOnRefreshListenerSupportSensors(classLoader));
            }
            catch (ClassNotFoundException e) {
                logger.debug("Deactivate instrumentation for class {}", (Object)ON_REFRESH_LISTENER_SUPPORT);
            }
        }
        return new DefaultSubTransformer("UserActionTransformer", new ArrayList<SensorGroup<InstructionSensor>>(), methodSensors, classLoader, warningsAsErrors);
    }

    private SensorGroup<MethodSensor> generateOnClickListenerSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> view = Class.forName(VIEW, false, classLoader);
        Class<?> listener = Class.forName(ON_CLICK_LISTENER, false, classLoader);
        Method onClick = listener.getDeclaredMethod("onClick", view);
        Class<?> callback = Class.forName("com.dynatrace.android.callback.Callback", false, classLoader);
        Method instr_onClick_ENTER = callback.getDeclaredMethod("onClick_ENTER", view);
        Method instr_onClick_EXIT = callback.getDeclaredMethod("onClick_EXIT", new Class[0]);
        return new SensorGroupImpl<MethodSensor>(listener, new MethodSensorImpl(onClick, MethodSensorImpl.generateDefaultMethodTransformer(instr_onClick_ENTER, instr_onClick_EXIT)));
    }

    private SensorGroup<MethodSensor> generateOnItemClickListenerSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> adapterView = Class.forName(ADAPTER_VIEW, false, classLoader);
        Class<?> view = Class.forName(VIEW, false, classLoader);
        Class<?> listener = Class.forName(ON_ITEM_CLICK_LISTENER, false, classLoader);
        Method onItemClick = listener.getDeclaredMethod("onItemClick", adapterView, view, Integer.TYPE, Long.TYPE);
        Class<?> callback = Class.forName("com.dynatrace.android.callback.Callback", false, classLoader);
        Method instr_onItemClick_ENTER = callback.getDeclaredMethod("onItemClick_ENTER", view, Integer.TYPE);
        Method instr_onItemClick_EXIT = callback.getDeclaredMethod("onItemClick_EXIT", new Class[0]);
        return new SensorGroupImpl<MethodSensor>(listener, new MethodSensorImpl(onItemClick, UserActionTransformerFactory.generateAdapterViewMethodSensor(instr_onItemClick_ENTER, instr_onItemClick_EXIT)));
    }

    private SensorGroup<MethodSensor> generateOnItemSelectedListenerSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> adapterView = Class.forName(ADAPTER_VIEW, false, classLoader);
        Class<?> view = Class.forName(VIEW, false, classLoader);
        Class<?> listener = Class.forName(ON_ITEM_SELECTED_LISTENER, false, classLoader);
        Method onItemSelected = listener.getDeclaredMethod("onItemSelected", adapterView, view, Integer.TYPE, Long.TYPE);
        Class<?> callback = Class.forName("com.dynatrace.android.callback.Callback", false, classLoader);
        Method instr_onItemSelected_ENTER = callback.getDeclaredMethod("onItemSelected_ENTER", view, Integer.TYPE);
        Method instr_onItemSelected_EXIT = callback.getDeclaredMethod("onItemSelected_EXIT", new Class[0]);
        return new SensorGroupImpl<MethodSensor>(listener, new MethodSensorImpl(onItemSelected, UserActionTransformerFactory.generateAdapterViewMethodSensor(instr_onItemSelected_ENTER, instr_onItemSelected_EXIT)));
    }

    private SensorGroup<MethodSensor> generateOnMenuItemClickListenerSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> menuItem = Class.forName(MENU_ITEM, false, classLoader);
        Class<?> listener = Class.forName(ON_MENU_ITEM_CLICK_LISTENER, false, classLoader);
        Method onMenuItemClick = listener.getDeclaredMethod("onMenuItemClick", menuItem);
        Class<?> callback = Class.forName("com.dynatrace.android.callback.Callback", false, classLoader);
        Method instr_onMenuItemClick_ENTER = callback.getDeclaredMethod("onMenuItemClick_ENTER", menuItem);
        Method instr_onMenuItemClick_EXIT = callback.getDeclaredMethod("onMenuItemClick_EXIT", new Class[0]);
        return new SensorGroupImpl<MethodSensor>(listener, new MethodSensorImpl(onMenuItemClick, MethodSensorImpl.generateDefaultMethodTransformer(instr_onMenuItemClick_ENTER, instr_onMenuItemClick_EXIT)));
    }

    private SensorGroup<MethodSensor> generateActivitySensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> menuItem = Class.forName(MENU_ITEM, false, classLoader);
        Class<?> activity = Class.forName(ACTIVITY, false, classLoader);
        Method onOptionsItemSelected = activity.getDeclaredMethod("onOptionsItemSelected", menuItem);
        Class<?> callback = Class.forName("com.dynatrace.android.callback.Callback", false, classLoader);
        Method instr_onOptionsItemSelected_ENTER = callback.getDeclaredMethod("onOptionsItemSelected_ENTER", menuItem);
        Method instr_onOptionsItemSelected_EXIT = callback.getDeclaredMethod("onOptionsItemSelected_EXIT", new Class[0]);
        return new SensorGroupImpl<MethodSensor>(activity, new MethodSensorImpl(onOptionsItemSelected, MethodSensorImpl.generateDefaultMethodTransformer(instr_onOptionsItemSelected_ENTER, instr_onOptionsItemSelected_EXIT)));
    }

    private SensorGroup<MethodSensor> generateOnPageChangeListenerSupportSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> listener = Class.forName(ON_PAGE_CHANGE_LISTENER_SUPPORT, false, classLoader);
        Method onPageSelected = listener.getDeclaredMethod("onPageSelected", Integer.TYPE);
        Class<?> callback = Class.forName("com.dynatrace.android.callback.Callback", false, classLoader);
        Method instr_onPageSelected_ENTER = callback.getDeclaredMethod("onPageSelected_ENTER", Integer.TYPE);
        Method instr_onPageSelected_EXIT = callback.getDeclaredMethod("onPageSelected_EXIT", new Class[0]);
        return new SensorGroupImpl<MethodSensor>(listener, new MethodSensorImpl(onPageSelected, MethodSensorImpl.generateDefaultMethodTransformer(instr_onPageSelected_ENTER, instr_onPageSelected_EXIT)));
    }

    private SensorGroup<MethodSensor> generateOnRefreshListenerSupportSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> listener = Class.forName(ON_REFRESH_LISTENER_SUPPORT, false, classLoader);
        Method onRefresh = listener.getDeclaredMethod("onRefresh", new Class[0]);
        Class<?> callback = Class.forName("com.dynatrace.android.callback.Callback", false, classLoader);
        Method instr_onRefresh_ENTER = callback.getDeclaredMethod("onRefresh_ENTER", new Class[0]);
        Method instr_onRefresh_EXIT = callback.getDeclaredMethod("onRefresh_EXIT", new Class[0]);
        return new SensorGroupImpl<MethodSensor>(listener, new MethodSensorImpl(onRefresh, MethodSensorImpl.generateDefaultMethodTransformer(instr_onRefresh_ENTER, instr_onRefresh_EXIT)));
    }

    private SensorGroup<MethodSensor> generateOnPageChangeListenerAndroidXSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> listener = Class.forName(ON_PAGE_CHANGE_LISTENER_ANDROID_X, false, classLoader);
        Method onPageSelected = listener.getDeclaredMethod("onPageSelected", Integer.TYPE);
        Class<?> callback = Class.forName("com.dynatrace.android.callback.Callback", false, classLoader);
        Method instr_onPageSelected_ENTER = callback.getDeclaredMethod("onPageSelected_ENTER", Integer.TYPE);
        Method instr_onPageSelected_EXIT = callback.getDeclaredMethod("onPageSelected_EXIT", new Class[0]);
        return new SensorGroupImpl<MethodSensor>(listener, new MethodSensorImpl(onPageSelected, MethodSensorImpl.generateDefaultMethodTransformer(instr_onPageSelected_ENTER, instr_onPageSelected_EXIT)));
    }

    private SensorGroup<MethodSensor> generateOnRefreshListenerAndroidXSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> listener = Class.forName(ON_REFRESH_LISTENER_ANDROID_X, false, classLoader);
        Method onRefresh = listener.getDeclaredMethod("onRefresh", new Class[0]);
        Class<?> callback = Class.forName("com.dynatrace.android.callback.Callback", false, classLoader);
        Method instr_onRefresh_ENTER = callback.getDeclaredMethod("onRefresh_ENTER", new Class[0]);
        Method instr_onRefresh_EXIT = callback.getDeclaredMethod("onRefresh_EXIT", new Class[0]);
        return new SensorGroupImpl<MethodSensor>(listener, new MethodSensorImpl(onRefresh, MethodSensorImpl.generateDefaultMethodTransformer(instr_onRefresh_ENTER, instr_onRefresh_EXIT)));
    }

    public static class Sensors
    implements Serializable {
        private boolean onClickListener;
        private boolean onItemClickListener;
        private boolean onItemSelectedListener;
        private boolean onMenuItemClickListener;
        private boolean onPageChangeListener;
        private boolean onRefreshListener;
        private boolean onOptionsItemSelected;

        private Sensors(boolean onClickListener, boolean onItemClickListener, boolean onItemSelectedListener, boolean onMenuItemClickListener, boolean onPageChangeListener, boolean onRefreshListener, boolean onOptionsItemSelected) {
            this.onClickListener = onClickListener;
            this.onItemClickListener = onItemClickListener;
            this.onItemSelectedListener = onItemSelectedListener;
            this.onMenuItemClickListener = onMenuItemClickListener;
            this.onPageChangeListener = onPageChangeListener;
            this.onRefreshListener = onRefreshListener;
            this.onOptionsItemSelected = onOptionsItemSelected;
        }

        public static Sensors allSensorsActivated() {
            return new Builder().withOnClickListener(true).withOnItemClickListener(true).withOnItemSelectedListener(true).withOnMenuItemClickListener(true).withOnPageChangeListener(true).withOnRefreshListener(true).withOnOptionsItemSelected(true).build();
        }

        public static class Builder {
            private boolean onClickListener = false;
            private boolean onItemClickListener = false;
            private boolean onItemSelectedListener = false;
            private boolean onMenuItemClickListener = false;
            private boolean onPageChangeListener = false;
            private boolean onRefreshListener = false;
            private boolean onOptionsItemSelected = false;

            public Builder withOnClickListener(boolean onClickListener) {
                this.onClickListener = onClickListener;
                return this;
            }

            public Builder withOnItemClickListener(boolean onItemClickListener) {
                this.onItemClickListener = onItemClickListener;
                return this;
            }

            public Builder withOnItemSelectedListener(boolean onItemSelectedListener) {
                this.onItemSelectedListener = onItemSelectedListener;
                return this;
            }

            public Builder withOnMenuItemClickListener(boolean onMenuItemClickListener) {
                this.onMenuItemClickListener = onMenuItemClickListener;
                return this;
            }

            public Builder withOnPageChangeListener(boolean onPageChangeListener) {
                this.onPageChangeListener = onPageChangeListener;
                return this;
            }

            public Builder withOnRefreshListener(boolean onRefreshListener) {
                this.onRefreshListener = onRefreshListener;
                return this;
            }

            public Builder withOnOptionsItemSelected(boolean onOptionsItemSelected) {
                this.onOptionsItemSelected = onOptionsItemSelected;
                return this;
            }

            public Sensors build() {
                return new Sensors(this.onClickListener, this.onItemClickListener, this.onItemSelectedListener, this.onMenuItemClickListener, this.onPageChangeListener, this.onRefreshListener, this.onOptionsItemSelected);
            }
        }
    }
}

