/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory.replay;

import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.ReplaceInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class SessionReplayCompoundButtonTransformerFactory
implements TransformerFactory {
    private static final String COMPOUND_BUTTON = "android.widget.CompoundButton";
    private static final String COMPOUND_BUTTON_ON_CHECKED_CHANGED_LISTENER = "android.widget.CompoundButton$OnCheckedChangeListener";
    private static final String RADIO_GROUP = "android.widget.RadioGroup";
    private static final String RADIO_GROUP_ON_CHECKED_CHANGED_LISTENER = "android.widget.RadioGroup$OnCheckedChangeListener";

    @Override
    public SubTransformer generateTransformer(ClassLoader classLoader, boolean warningsAsErrors) throws Exception {
        ArrayList<SensorGroup<InstructionSensor>> instructionSensors = new ArrayList<SensorGroup<InstructionSensor>>();
        instructionSensors.add(this.generateOnRadioGroupCheckedSensors(classLoader));
        instructionSensors.add(this.generateCompoundButtonCheckedSensors(classLoader));
        return new DefaultSubTransformer("CompoundButtonTransformer", instructionSensors, new ArrayList<SensorGroup<MethodSensor>>(), classLoader, warningsAsErrors);
    }

    private SensorGroup<InstructionSensor> generateOnRadioGroupCheckedSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> radioGroup = Class.forName(RADIO_GROUP, false, classLoader);
        Class<?> listener = Class.forName(RADIO_GROUP_ON_CHECKED_CHANGED_LISTENER, false, classLoader);
        Method setOnCheckedChanged = radioGroup.getDeclaredMethod("setOnCheckedChangeListener", listener);
        Class<?> callback = Class.forName("com.dynatrace.android.internal.api.InstrumentorAPI", false, classLoader);
        Method instr_setOnCheckedChanged = callback.getDeclaredMethod("setOnCheckedChangedListener", radioGroup, listener);
        return new SensorGroupImpl<InstructionSensor>(radioGroup, new ReplaceInstructionSensor(setOnCheckedChanged, instr_setOnCheckedChanged));
    }

    private SensorGroup<InstructionSensor> generateCompoundButtonCheckedSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> compoundButton = Class.forName(COMPOUND_BUTTON, false, classLoader);
        Class<?> listener = Class.forName(COMPOUND_BUTTON_ON_CHECKED_CHANGED_LISTENER, false, classLoader);
        Method setOnCheckedChanged = compoundButton.getDeclaredMethod("setOnCheckedChangeListener", listener);
        Class<?> callback = Class.forName("com.dynatrace.android.internal.api.InstrumentorAPI", false, classLoader);
        Method instr_setOnCheckedChanged = callback.getDeclaredMethod("setOnCheckedChangedListener", compoundButton, listener);
        return new SensorGroupImpl<InstructionSensor>(compoundButton, new ReplaceInstructionSensor(setOnCheckedChanged, instr_setOnCheckedChanged));
    }
}

