/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory.replay;

import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InsertBeforeInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.sensor.method.StartMethodTransformation;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionReplayTableReloadTransformerFactory
implements TransformerFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)"SessionReplayTableReloadTransformerFactory");
    private static final String ABS_LIST_VIEW = "android.widget.AbsListView";
    private static final String ANDROID_VIEW = "android.view.View";
    private static final String LIST_ADAPTER = "android.widget.ListAdapter";
    private static final String RECYCLER_VIEW = "androidx.recyclerview.widget.RecyclerView";
    private static final String RECYCLER_VIEW_ADAPTER = "androidx.recyclerview.widget.RecyclerView$Adapter";

    @Override
    public SubTransformer generateTransformer(ClassLoader classLoader, boolean warningsAsErrors) throws Exception {
        ArrayList<SensorGroup<MethodSensor>> methodSensors = new ArrayList<SensorGroup<MethodSensor>>();
        try {
            methodSensors.add(this.getGenerateRecyclerViewTableReloadSensor(classLoader));
        }
        catch (ClassNotFoundException e) {
            logger.debug("Deactivate instrumentation for RecyclerView table reload events, because it is not part of the classpath");
        }
        return new DefaultSubTransformer("SessionReplayTableReloadTransformer", Collections.singletonList(this.generateAbsListSensors(classLoader)), methodSensors, classLoader, warningsAsErrors);
    }

    private SensorGroup<InstructionSensor> generateAbsListSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> listView = Class.forName(ABS_LIST_VIEW, false, classLoader);
        Class<?> adapter = Class.forName(LIST_ADAPTER, false, classLoader);
        Class<?> androidView = Class.forName(ANDROID_VIEW, false, classLoader);
        Method listSetAdapter = listView.getDeclaredMethod("setAdapter", adapter);
        Class<?> callback = Class.forName("com.dynatrace.android.internal.api.InstrumentorAPI", false, classLoader);
        Method instrumentSetAdapter = callback.getDeclaredMethod("setAdapter", androidView, adapter);
        InsertBeforeInstructionSensor sensorListSetAdapter = new InsertBeforeInstructionSensor(listSetAdapter, instrumentSetAdapter);
        return new SensorGroupImpl<InstructionSensor>(listView, sensorListSetAdapter);
    }

    private SensorGroup<MethodSensor> getGenerateRecyclerViewTableReloadSensor(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> recyclerView = Class.forName(RECYCLER_VIEW, false, classLoader);
        Class<?> adapter = Class.forName(RECYCLER_VIEW_ADAPTER, false, classLoader);
        Method setAdapter = recyclerView.getDeclaredMethod("setAdapter", adapter);
        Class<?> callback = Class.forName("com.dynatrace.android.internal.api.recyclerview.callback.RecyclerViewCallback", false, classLoader);
        Method instrumentedSetAdapter = callback.getDeclaredMethod("setAdapter", recyclerView, adapter);
        return new SensorGroupImpl<MethodSensor>(clazz -> clazz == recyclerView, new MethodSensorImpl(setAdapter, new StartMethodTransformation(instrumentedSetAdapter, ParameterInstructionProvider.withThisAndAllParameters(setAdapter))));
    }
}

