/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.transformation;

import com.dynatrace.android.instrumentation.Instrumentor;
import com.dynatrace.tools.android.InstrumentationException;
import com.dynatrace.tools.android.transformation.BuildHandler;
import com.dynatrace.tools.android.transformation.ClassNameUtil;
import com.dynatrace.tools.android.transformation.FileTransformer;
import com.dynatrace.tools.android.transformation.JarTransformer;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentedBuild
implements BuildHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"InstrumentedBuild");
    private Instrumentor instrumentor;

    public InstrumentedBuild(Instrumentor instrumentor) {
        this.instrumentor = instrumentor;
    }

    public static void copyInputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int nRead;
        byte[] data = new byte[4096];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            outputStream.write(data, 0, nRead);
        }
    }

    private static byte[] toByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        InstrumentedBuild.copyInputStream(inputStream, buffer);
        return buffer.toByteArray();
    }

    @Override
    public FileTransformer getFileTransformer(String name, boolean changed) {
        return (source, dest, className) -> this.transformFile(source, dest, className);
    }

    private void transformFile(Path source, Path dest, String className) {
        this.transformContent(() -> Files.readAllBytes(source), bytes -> Files.write(dest, bytes, new OpenOption[0]), className);
    }

    private void transformContent(BytesReader reader, BytesWriter writer, String className) throws InstrumentationException {
        try {
            writer.write(this.instrumentor.instrument(className, reader.read()));
        }
        catch (UnsupportedClassVersionError error) {
            throw new InstrumentationException("Unable to instrument class " + className + " because it was compiled with a higher Java version than the one used for this build. Please adapt your JRE accordingly to https://www.dynatrace.com/support/help/shortlink/dynatrace-android-gradle-plugin-overview#requirements", error);
        }
        catch (IOException exception) {
            throw new InstrumentationException("Unable to instrument class " + className, exception);
        }
        catch (Throwable throwable) {
            throw new InstrumentationException("Unable to instrument class " + className + ". Please open a support ticket", throwable);
        }
    }

    @Override
    public JarTransformer getJarTransformer(String name, boolean changed) {
        return (source, dest) -> this.transformJar(source, dest);
    }

    private void transformJar(Path jarFile, Path output) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(output.toFile());
             ZipOutputStream jos = new ZipOutputStream(fos);
             ZipFile jar = new ZipFile(jarFile.toFile());){
            Enumeration<? extends ZipEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry == null) continue;
                if (entry.isDirectory()) {
                    logger.debug("Ignore directory " + entry.getName());
                    continue;
                }
                if (!entry.getName().endsWith(".class")) {
                    logger.debug("Ignore non class file " + entry.getName());
                    continue;
                }
                if (entry.getName().startsWith("META-INF/versions/")) {
                    logger.debug("Ignore non Java 8 class " + entry.getName());
                    continue;
                }
                logger.debug("Store jar entry " + entry.getName());
                jos.putNextEntry(new JarEntry(entry.getName()));
                try (InputStream is = jar.getInputStream(entry);){
                    String className = ClassNameUtil.convertFileNameToClassName(entry.getName());
                    this.transformContent(() -> InstrumentedBuild.toByteArray(is), jos::write, className);
                }
                jos.closeEntry();
            }
        }
    }

    static interface BytesReader {
        public byte[] read() throws IOException;
    }

    static interface BytesWriter {
        public void write(byte[] var1) throws IOException;
    }
}

