/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.filter.ExclusionManager;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.instrumentor.InstructionInstrumentor;
import com.dynatrace.android.instrumentation.transform.instrumentor.LambdaInstrumentor;
import com.dynatrace.android.instrumentation.transform.instrumentor.MethodInstrumentor;
import java.util.List;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class DefaultSubTransformer
implements SubTransformer {
    private final List<SensorGroup<InstructionSensor>> instructionSensors;
    private final List<SensorGroup<MethodSensor>> methodSensors;
    private final String name;
    private final InstructionInstrumentor instructionInstrumentor;
    private final MethodInstrumentor methodInstrumentor;
    private final LambdaInstrumentor lambdaInstrumentor;

    public DefaultSubTransformer(String name, List<SensorGroup<InstructionSensor>> instructionSensors, List<SensorGroup<MethodSensor>> methodSensors, ClassResolver classResolver) {
        this.name = name;
        this.instructionSensors = instructionSensors;
        this.methodSensors = methodSensors;
        this.instructionInstrumentor = new InstructionInstrumentor(classResolver, instructionSensors);
        this.methodInstrumentor = new MethodInstrumentor(methodSensors);
        this.lambdaInstrumentor = new LambdaInstrumentor(classResolver, instructionSensors, methodSensors);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean transformClass(ClassInfo classInfo, ClassNode classNode, ExclusionManager exclusionManager) {
        return false;
    }

    @Override
    public boolean transformMethod(ClassInfo classInfo, ClassNode classNode, MethodNode methodNode, ExclusionManager exclusionManager) {
        boolean modified = false;
        modified |= this.instructionInstrumentor.transformMethod(methodNode, exclusionManager);
        modified |= this.methodInstrumentor.transformMethod(classInfo, methodNode);
        return modified |= this.lambdaInstrumentor.transformMethod(classNode, methodNode, exclusionManager);
    }

    @Override
    public boolean shouldBeInstrumented(ClassInfo classInfo) {
        return this.instructionSensors.stream().noneMatch(sensor -> sensor.matchClass(classInfo));
    }
}

