/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory.replay;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.ReplaceInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;

public class SessionReplayCompoundButtonTransformerFactory
implements TransformerFactory {
    private static final String COMPOUND_BUTTON = "android.widget.CompoundButton";
    private static final String RADIO_GROUP = "android.widget.RadioGroup";

    @Override
    public SubTransformer generateTransformer(ClassResolver classResolver) throws Exception {
        ArrayList<SensorGroup<InstructionSensor>> instructionSensors = new ArrayList<SensorGroup<InstructionSensor>>();
        instructionSensors.add(this.generateOnRadioGroupCheckedSensors(classResolver));
        instructionSensors.add(this.generateCompoundButtonCheckedSensors(classResolver));
        return new DefaultSubTransformer("CompoundButtonTransformer", instructionSensors, new ArrayList<SensorGroup<MethodSensor>>(), classResolver);
    }

    private SensorGroup<InstructionSensor> generateOnRadioGroupCheckedSensors(ClassResolver classResolver) {
        MethodInstruction setOnCheckedSignature = MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.internal.api.InstrumentorAPI"), "setOnCheckedChangedListener", "(Landroid/widget/RadioGroup;Landroid/widget/RadioGroup$OnCheckedChangeListener;)V");
        return new SensorGroupImpl<InstructionSensor>(classResolver.resolveClass(RADIO_GROUP), new ReplaceInstructionSensor(MethodInstruction.createPublicMethodInstruction(Utils.dotToSlash(RADIO_GROUP), "setOnCheckedChangeListener", "(Landroid/widget/RadioGroup$OnCheckedChangeListener;)V"), setOnCheckedSignature));
    }

    private SensorGroup<InstructionSensor> generateCompoundButtonCheckedSensors(ClassResolver classResolver) {
        MethodInstruction setOnCheckedSignature = MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.internal.api.InstrumentorAPI"), "setOnCheckedChangedListener", "(Landroid/widget/CompoundButton;Landroid/widget/CompoundButton$OnCheckedChangeListener;)V");
        return new SensorGroupImpl<InstructionSensor>(classResolver.resolveClass(COMPOUND_BUTTON), new ReplaceInstructionSensor(MethodInstruction.createPublicMethodInstruction(Utils.dotToSlash(COMPOUND_BUTTON), "setOnCheckedChangeListener", "(Landroid/widget/CompoundButton$OnCheckedChangeListener;)V"), setOnCheckedSignature));
    }
}

