/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory.replay;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.ReplaceInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.ExitConstructorTransformation;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.shared.TransformerUtils;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionReplayScrollTransformerFactory
implements TransformerFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)"SessionReplayScrollTransformerFactory");
    private static final String ABS_LIST_VIEW = "android.widget.AbsListView";
    private static final String CONTEXT = "android.content.Context";
    private static final String ATTRIBUTE_SET = "android.util.AttributeSet";
    private static final String RECYCLER_VIEW = "androidx.recyclerview.widget.RecyclerView";
    private static final String RECYCLER_VIEW_DESCRIPTOR = "(L" + Utils.dotToSlash("android.content.Context") + ";L" + Utils.dotToSlash("android.util.AttributeSet") + ";I)V";
    private static final String NESTED_SCROLL_VIEW = "androidx.core.widget.NestedScrollView";

    @Override
    public SubTransformer generateTransformer(ClassResolver classResolver) throws Exception {
        ArrayList<SensorGroup<MethodSensor>> methodSensors = new ArrayList<SensorGroup<MethodSensor>>();
        methodSensors.add(this.generateRecyclerViewSensor());
        methodSensors.add(this.generateNestedScrollViewSensor());
        return new DefaultSubTransformer("SessionReplayScrollTransformer", Collections.singletonList(this.generateListViewSensor(classResolver)), methodSensors, classResolver);
    }

    private SensorGroup<InstructionSensor> generateListViewSensor(ClassResolver classResolver) {
        ReplaceInstructionSensor sensorSetOnScrollListener = new ReplaceInstructionSensor(MethodInstruction.createPublicMethodInstruction(Utils.dotToSlash(ABS_LIST_VIEW), "setOnScrollListener", "(Landroid/widget/AbsListView$OnScrollListener;)V"), MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.internal.api.InstrumentorAPI"), "setOnScrollListener", "(Landroid/widget/AbsListView;Landroid/widget/AbsListView$OnScrollListener;)V"));
        return new SensorGroupImpl<InstructionSensor>(classResolver.resolveClass(ABS_LIST_VIEW), sensorSetOnScrollListener);
    }

    private SensorGroup<MethodSensor> generateNestedScrollViewSensor() {
        MethodInstruction svCallbackSignature = MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.internal.api.nestedscrollview.callback.NestedScrollViewCallback"), "wrapOnScrollChangeListener", "(Landroidx/core/widget/NestedScrollView$OnScrollChangeListener;)Landroidx/core/widget/NestedScrollView$OnScrollChangeListener;");
        MethodTransformation setterTransformation = (methodNode, startParameterIndex) -> TransformerUtils.insertAtMethodStart(methodNode, instructions -> {
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            instructions.add((AbstractInsnNode)Utils.generateMethodInstructionNode(svCallbackSignature));
            instructions.add((AbstractInsnNode)new VarInsnNode(58, 1));
        });
        MethodTransformation constructorTransformation = (methodNode, startParameterIndex) -> TransformerUtils.insertAtMethodExitWithoutExceptionHandling(methodNode, instructions -> {
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new InsnNode(89));
            instructions.add((AbstractInsnNode)new FieldInsnNode(180, "androidx/core/widget/NestedScrollView", "mOnScrollChangeListener", "Landroidx/core/widget/NestedScrollView$OnScrollChangeListener;"));
            instructions.add((AbstractInsnNode)Utils.generateMethodInstructionNode(svCallbackSignature));
            instructions.add((AbstractInsnNode)new FieldInsnNode(181, "androidx/core/widget/NestedScrollView", "mOnScrollChangeListener", "Landroidx/core/widget/NestedScrollView$OnScrollChangeListener;"));
        });
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> NESTED_SCROLL_VIEW.equals(otherClassInfo.getName()), new MethodSensorImpl(new MethodInfo("<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", 1, null, new ArrayList<String>()), constructorTransformation), new MethodSensorImpl(new MethodInfo("setOnScrollChangeListener", "(Landroidx/core/widget/NestedScrollView$OnScrollChangeListener;)V", 1, null, new ArrayList<String>()), setterTransformation));
    }

    private SensorGroup<MethodSensor> generateRecyclerViewSensor() {
        MethodInstruction addOnScrollListener = MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.internal.api.recyclerview.callback.RecyclerViewCallback"), "addOnScrollListener", "(Landroidx/recyclerview/widget/RecyclerView;)V");
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> RECYCLER_VIEW.equals(otherClassInfo.getName()), new MethodSensorImpl(new MethodInfo("<init>", RECYCLER_VIEW_DESCRIPTOR, 1, null, new ArrayList<String>()), new ExitConstructorTransformation(addOnScrollListener, ParameterInstructionProvider.withThis())), new MethodSensorImpl(new MethodInfo("clearOnScrollListeners", "()V", 1, null, new ArrayList<String>()), new ExitConstructorTransformation(addOnScrollListener, ParameterInstructionProvider.withThis())));
    }
}

