/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory.replay;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InsertBeforeInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.ReplaceInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;
import java.util.function.Function;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.VarInsnNode;

public class SessionReplayWebViewTransformerFactory
implements TransformerFactory {
    private static final String WEB_VIEW = "android.webkit.WebView";

    @Override
    public SubTransformer generateTransformer(ClassResolver classResolver) throws Exception {
        ArrayList<SensorGroup<InstructionSensor>> instructionSensors = new ArrayList<SensorGroup<InstructionSensor>>();
        instructionSensors.add(this.generateWebViewSensors(classResolver));
        return new DefaultSubTransformer("SessionReplayWebViewTransformer", instructionSensors, new ArrayList<SensorGroup<MethodSensor>>(), classResolver);
    }

    private SensorGroup<InstructionSensor> generateWebViewSensors(ClassResolver classResolver) {
        Function<Integer, InsnList> transformer = startIndex -> {
            InsnList instructions = new InsnList();
            instructions.add((AbstractInsnNode)new VarInsnNode(25, startIndex.intValue()));
            instructions.add((AbstractInsnNode)Utils.generateMethodInstructionNode(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.internal.api.InstrumentorAPI"), "trackWebView", "(Landroid/webkit/WebView;)V")));
            return instructions;
        };
        String webViewClassName = Utils.dotToSlash(WEB_VIEW);
        InsertBeforeInstructionSensor sensorLoadUrlOnlyString = new InsertBeforeInstructionSensor(MethodInstruction.createPublicMethodInstruction(webViewClassName, "loadUrl", "(Ljava/lang/String;)V"), transformer);
        InsertBeforeInstructionSensor sensorLoadUrlWithMap = new InsertBeforeInstructionSensor(MethodInstruction.createPublicMethodInstruction(webViewClassName, "loadUrl", "(Ljava/lang/String;Ljava/util/Map;)V"), transformer);
        ReplaceInstructionSensor sensorSetWebViewClient = new ReplaceInstructionSensor(MethodInstruction.createPublicMethodInstruction(webViewClassName, "setWebViewClient", "(Landroid/webkit/WebViewClient;)V"), MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.internal.api.InstrumentorAPI"), "setWebViewClient", "(Landroid/webkit/WebView;Landroid/webkit/WebViewClient;)V"));
        return new SensorGroupImpl<InstructionSensor>(classResolver.resolveClass(WEB_VIEW), sensorLoadUrlOnlyString, sensorLoadUrlWithMap, sensorSetWebViewClient);
    }
}

