/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.instrumentor;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.filter.ExclusionManager;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstructionInstrumentor {
    private static final Logger logger = LoggerFactory.getLogger((String)"InstructionInstrumentor");
    private final ClassResolver classResolver;
    private final List<SensorGroup<InstructionSensor>> sensors;

    public InstructionInstrumentor(ClassResolver classResolver, List<SensorGroup<InstructionSensor>> sensors) {
        this.classResolver = classResolver;
        this.sensors = sensors;
    }

    public boolean transformMethod(MethodNode method, ExclusionManager exclusionManager) {
        boolean modified = false;
        ArrayList<MethodInsnNode> methodInstructions = new ArrayList<MethodInsnNode>();
        for (AbstractInsnNode instruction : method.instructions) {
            if (!(instruction instanceof MethodInsnNode)) continue;
            methodInstructions.add((MethodInsnNode)instruction);
        }
        for (MethodInsnNode node : methodInstructions) {
            ClassInfo classInfo;
            if (node.owner.startsWith("[")) continue;
            String className = Type.getObjectType((String)node.owner).getClassName();
            if (exclusionManager.filterInvokeInstruction(className, node.name, node.desc)) {
                logger.debug("exclude invoke instruction {}.{}{}", new Object[]{className, node.name, node.desc});
                continue;
            }
            try {
                classInfo = this.classResolver.resolveClass(className);
            }
            catch (Throwable t) {
                logger.info("skip instruction with unknown method call {}.{}{}, {}", new Object[]{className, node.name, node.desc, t.toString()});
                throw t;
            }
            Optional<InstructionSensor> result = this.sensors.stream().filter(sensorGroup -> sensorGroup.matchClass(classInfo)).flatMap(sensorGroup -> sensorGroup.getSensors().stream()).filter(sensor -> sensor.matchInstruction(classInfo, node.name, node.desc)).findAny();
            if (!result.isPresent()) continue;
            logger.debug("Instrument method call {}.{}{}", new Object[]{className, node.name, node.desc});
            result.get().transform(method, node);
            modified = true;
        }
        return modified;
    }
}

