/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.instrumentor;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import java.util.List;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodInstrumentor {
    private static final Logger logger = LoggerFactory.getLogger((String)"MethodInstrumentor");
    private final List<SensorGroup<MethodSensor>> sensors;

    public MethodInstrumentor(List<SensorGroup<MethodSensor>> sensors) {
        this.sensors = sensors;
    }

    public boolean transformMethod(ClassInfo classInfo, MethodNode methodNode) {
        boolean modified;
        List matches = this.sensors.stream().filter(sensorGroup -> sensorGroup.matchClass(classInfo)).flatMap(sensorGroup -> sensorGroup.getSensors().stream()).filter(methodSensor -> methodSensor.matchMethod(classInfo, methodNode.name, methodNode.desc, false)).collect(Collectors.toList());
        boolean bl = modified = matches.size() > 0;
        if (modified) {
            logger.debug("Instrumented method {}{}", (Object)methodNode.name, (Object)methodNode.desc);
        }
        for (MethodSensor methodSensor2 : matches) {
            methodSensor2.transformMethod(methodNode, (methodNode.access & 8) == 0 ? 1 : 0);
        }
        return modified;
    }
}

