/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import com.dynatrace.android.instrumentation.ClassLoaderClassResolver;
import com.dynatrace.android.instrumentation.Instrumentor;
import com.dynatrace.android.instrumentation.filter.ExclusionManager;
import com.dynatrace.android.instrumentation.sensor.agent.InstrumentationFlavor;
import com.dynatrace.tools.android.BuildArtifactTransformer;
import com.dynatrace.tools.android.InstrumentationException;
import com.dynatrace.tools.android.InstrumentorConfigurator;
import com.dynatrace.tools.android.api.Configuration;
import com.dynatrace.tools.android.api.ExcludeOptions;
import com.dynatrace.tools.android.classpath.ClassPathAnalyzer;
import com.dynatrace.tools.android.transformation.BuildHandler;
import com.dynatrace.tools.android.transformation.InstrumentedBuild;
import com.dynatrace.tools.android.transformation.NonInstrumentedBuild;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTransformer<T> {
    private static final Logger logger = LoggerFactory.getLogger((String)"BaseTransformer");

    protected abstract Configuration determineConfiguration(T var1);

    public void transform(T transformData, boolean isIncremental) throws InstrumentationException, IOException {
        Configuration configuration = this.determineConfiguration(transformData);
        if (configuration != null) {
            logger.debug("{}", (Object)configuration);
            if (!configuration.isEnabled()) {
                logger.debug("Instrumentation is disabled");
                configuration = null;
            }
        }
        String txtIncremental = isIncremental ? "incremental" : "non-incremental";
        logger.debug("Start " + txtIncremental + " transformation");
        this.transform(transformData, isIncremental, configuration);
    }

    protected abstract void deleteOutputFiles(T var1) throws IOException;

    protected abstract Supplier<URL[]> getClassPathGenerator(T var1);

    protected abstract BuildArtifactTransformer<T> generateBuildArtifactTransformer(BuildHandler var1, boolean var2);

    protected abstract InstrumentationFlavor getInstrumentationFlavor(T var1);

    protected void transform(T transformData, boolean isIncremental, Configuration configuration) throws InstrumentationException, IOException {
        if (!isIncremental) {
            logger.debug("Delete all files for non-incremental build");
            this.deleteOutputFiles(transformData);
        }
        if (configuration == null) {
            this.generateBuildArtifactTransformer(new NonInstrumentedBuild(), isIncremental).handleTransformation(transformData);
        } else {
            Supplier<URL[]> classPathGenerator = this.getClassPathGenerator(transformData);
            try (URLClassLoader classLoader = URLClassLoader.newInstance(classPathGenerator.get(), null);){
                Instrumentor instrumentor;
                logger.debug("classLoader content " + Arrays.toString(classLoader.getURLs()));
                new ClassPathAnalyzer(classLoader).verifyClassPath(configuration.getSessionReplay().isEnabled());
                ExcludeOptions excludeOptions = configuration.getExclude();
                ExclusionManager exclusionManager = new ExclusionManager(excludeOptions.getClassLevelFilter(), excludeOptions.getMethodLevelFilter());
                try {
                    instrumentor = new InstrumentorConfigurator(configuration, this.getInstrumentationFlavor(transformData)).generateVariantSpecificInstrumentor(new ClassLoaderClassResolver(classLoader), exclusionManager);
                }
                catch (Exception e) {
                    throw new InstrumentationException("Unable to instantiate instrumentor, Please open a support ticket", e);
                }
                this.generateBuildArtifactTransformer(new InstrumentedBuild(instrumentor), isIncremental).handleTransformation(transformData);
            }
        }
    }
}

