/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import com.dynatrace.android.instrumentation.sensor.agent.InstrumentationFlavor;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class InstrumentationFlavorParser {
    private static final List<InstrumentationFlavor> VALID_VALUES = Arrays.asList(InstrumentationFlavor.FLUTTER, InstrumentationFlavor.CORDOVA, InstrumentationFlavor.REACT_NATIVE);
    private final List<InstrumentationFlavor> validValues;

    public InstrumentationFlavorParser() {
        this(VALID_VALUES);
    }

    public InstrumentationFlavorParser(List<InstrumentationFlavor> validValues) {
        this.validValues = validValues;
    }

    public InstrumentationFlavor parse(String value) throws IllegalArgumentException {
        if (value == null) {
            return InstrumentationFlavor.PLAIN;
        }
        InstrumentationFlavor instrFlavor = InstrumentationFlavor.valueOf(value.toUpperCase(Locale.ROOT));
        if (!this.validValues.contains((Object)instrFlavor)) {
            throw new IllegalArgumentException("value " + (Object)((Object)instrFlavor) + " is not allowed");
        }
        return instrFlavor;
    }
}

