/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.transformation;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.dynatrace.tools.android.BuildArtifactTransformer;
import com.dynatrace.tools.android.transformation.BuildHandler;
import com.dynatrace.tools.android.transformation.ClassNameUtil;
import com.dynatrace.tools.android.transformation.FileTransformer;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgpBuildArtifactTransformer
implements BuildArtifactTransformer<TransformInvocation> {
    private static final Logger logger = LoggerFactory.getLogger((String)"BuildArtifactTransformer");
    private final BuildHandler buildHandler;
    private final boolean isIncremental;

    public AgpBuildArtifactTransformer(BuildHandler buildHandler, boolean isIncremental) {
        this.buildHandler = buildHandler;
        this.isIncremental = isIncremental;
    }

    @Override
    public void handleTransformation(TransformInvocation transformInvocation) throws IOException {
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        for (TransformInput input : transformInvocation.getInputs()) {
            for (DirectoryInput dirInput : input.getDirectoryInputs()) {
                this.handleDirectoryInput(dirInput, outputProvider);
            }
            for (JarInput jarInput : input.getJarInputs()) {
                this.handleJarInput(jarInput, outputProvider);
            }
        }
    }

    private void handleDirectoryInput(DirectoryInput dirInput, TransformOutputProvider outputProvider) throws IOException {
        Set<Path> removedFiles;
        String name = dirInput.getName();
        Path output = outputProvider.getContentLocation(name, dirInput.getContentTypes(), dirInput.getScopes(), Format.DIRECTORY).toPath().toAbsolutePath();
        Path rootFile = dirInput.getFile().toPath();
        Map<Status, Set<Path>> changedFiles = this.handleDirectories(dirInput);
        logger.debug("Changed files: " + changedFiles);
        Set<Path> skippedFiles = changedFiles.get(Status.NOTCHANGED);
        if (skippedFiles != null) {
            for (Path file : skippedFiles) {
                logger.debug("Skip file/directory " + file);
            }
        }
        if ((removedFiles = changedFiles.get(Status.REMOVED)) != null) {
            List sortedList = removedFiles.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
            for (Path file : sortedList) {
                Path relativeFile = rootFile.relativize(file);
                Path outputFile = output.resolve(relativeFile);
                if (Files.isDirectory(outputFile, new LinkOption[0])) {
                    logger.debug("Remove directory " + outputFile);
                } else {
                    logger.debug("Remove file " + outputFile);
                }
                Files.deleteIfExists(outputFile);
            }
        }
        this.handleFileTransformation(changedFiles.get(Status.CHANGED), rootFile, output, this.buildHandler.getFileTransformer(name, true), Status.CHANGED);
        this.handleFileTransformation(changedFiles.get(Status.ADDED), rootFile, output, this.buildHandler.getFileTransformer(name, false), Status.ADDED);
    }

    private Map<Status, Set<Path>> handleDirectories(DirectoryInput dirInput) throws IOException {
        if (this.isIncremental) {
            return dirInput.getChangedFiles().entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(fileStatusEntry -> ((File)fileStatusEntry.getKey()).toPath(), Collectors.toSet())));
        }
        try (Stream<Path> paths = Files.walk(dirInput.getFile().toPath(), new FileVisitOption[0]);){
            Set classFiles = paths.filter(file -> !Files.isDirectory(file, new LinkOption[0])).collect(Collectors.toSet());
            HashMap<Status, Set<Path>> changes = new HashMap<Status, Set<Path>>();
            changes.put(Status.ADDED, classFiles);
            HashMap<Status, Set<Path>> hashMap = changes;
            return hashMap;
        }
    }

    private void handleJarInput(JarInput jarInput, TransformOutputProvider outputProvider) throws IOException {
        Path jarFile = jarInput.getFile().toPath();
        String name = jarInput.getName();
        Path output = outputProvider.getContentLocation(name, jarInput.getContentTypes(), jarInput.getScopes(), Format.JAR).toPath().toAbsolutePath();
        Status status = jarInput.getStatus();
        if (!this.isIncremental && status != Status.REMOVED) {
            status = Status.ADDED;
        }
        switch (status) {
            case NOTCHANGED: {
                logger.debug("Skip jar " + jarFile);
                break;
            }
            case REMOVED: {
                logger.debug("Remove jar " + output);
                Files.deleteIfExists(output);
                break;
            }
            case ADDED: 
            case CHANGED: {
                logger.debug("Store jar " + jarFile + " to " + output);
                if (status == Status.ADDED) {
                    Files.createDirectories(output.getParent(), new FileAttribute[0]);
                }
                this.buildHandler.getJarTransformer(name, status == Status.CHANGED).transformJar(jarFile, output);
            }
        }
    }

    private void handleFileTransformation(Set<Path> files, Path source, Path dest, FileTransformer handler, Status status) throws IOException {
        if (files == null) {
            return;
        }
        for (Path file : files) {
            if (Files.isDirectory(file, new LinkOption[0])) {
                logger.debug("Ignore directory " + file + " with status = " + status);
                continue;
            }
            if (!file.toString().endsWith(".class")) {
                logger.debug("Ignore non class file " + file);
                continue;
            }
            Path relativeFile = source.relativize(file);
            Path outputFile = dest.resolve(relativeFile);
            logger.debug("Store file " + file + " to " + outputFile);
            if (status == Status.ADDED) {
                Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
            }
            handler.transformFile(file, outputFile, ClassNameUtil.convertFileNameToClassName(relativeFile.toString()));
        }
    }
}

