/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.transformation;

import com.android.build.api.instrumentation.AsmClassVisitorFactory;
import com.android.build.api.instrumentation.ClassContext;
import com.android.build.api.instrumentation.ClassData;
import com.dynatrace.android.instrumentation.Instrumentor;
import com.dynatrace.android.instrumentation.filter.ClassLevelFilter;
import com.dynatrace.android.instrumentation.filter.ExclusionManager;
import com.dynatrace.android.instrumentation.filter.InstrumentableClassManager;
import com.dynatrace.android.instrumentation.filter.InstrumentableFilterProvider;
import com.dynatrace.android.instrumentation.sensor.agent.InstrumentationFlavor;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.tools.android.InstrumentationException;
import com.dynatrace.tools.android.InstrumentorConfigurator;
import com.dynatrace.tools.android.api.Configuration;
import com.dynatrace.tools.android.api.ExcludeOptions;
import com.dynatrace.tools.android.dsl.VariantConfiguration;
import com.dynatrace.tools.android.instrumentation.ClassContextClassResolver;
import com.dynatrace.tools.android.transformation.ClassVisitorWrapper;
import com.dynatrace.tools.android.transformation.DynatraceAsmInstrumentationParameters;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassVisitor;

public abstract class DynatraceClassVisitorFactory
implements AsmClassVisitorFactory<DynatraceAsmInstrumentationParameters> {
    public ClassVisitor createClassVisitor(ClassContext classContext, ClassVisitor classVisitor) {
        Configuration configuration = (Configuration)((DynatraceAsmInstrumentationParameters)this.getParameters().get()).getVariantConfiguration().get();
        InstrumentationFlavor instrFlavor = (InstrumentationFlavor)((Object)((DynatraceAsmInstrumentationParameters)this.getParameters().get()).getInstrumentationFlavor().get());
        ExcludeOptions excludeOptions = configuration.getExclude();
        ExclusionManager exclusionManager = new ExclusionManager(excludeOptions.getClassLevelFilter(), excludeOptions.getMethodLevelFilter());
        try {
            Instrumentor instrumentor = new InstrumentorConfigurator(configuration, instrFlavor).generateVariantSpecificInstrumentor(new ClassContextClassResolver(classContext), exclusionManager);
            return new ClassVisitorWrapper((Integer)this.getInstrumentationContext().getApiVersion().get(), classVisitor, instrumentor);
        }
        catch (Exception e) {
            throw new InstrumentationException("Unable to instantiate instrumentor, Please open a support ticket", e);
        }
    }

    public boolean isInstrumentable(ClassData classData) {
        Configuration configuration = (Configuration)((DynatraceAsmInstrumentationParameters)this.getParameters().get()).getVariantConfiguration().get();
        InstrumentationFlavor instrFlavor = (InstrumentationFlavor)((Object)((DynatraceAsmInstrumentationParameters)this.getParameters().get()).getInstrumentationFlavor().get());
        InstrumentorConfigurator configurator = new InstrumentorConfigurator(configuration, instrFlavor);
        List<TransformerFactory> factories = configurator.selectTransformerFactories();
        ArrayList<ClassLevelFilter> filters = new ArrayList<ClassLevelFilter>();
        filters.addAll(InstrumentableFilterProvider.defaultFilters());
        filters.addAll(((VariantConfiguration)((DynatraceAsmInstrumentationParameters)this.getParameters().get()).getVariantConfiguration().get()).getExclude().getClassLevelFilter());
        filters.addAll(InstrumentableFilterProvider.transformerFilters(factories));
        InstrumentableClassManager manager = new InstrumentableClassManager(filters, InstrumentableFilterProvider.mandatoryClasses(factories));
        return manager.isInstrumentable(classData.getClassName());
    }
}

