/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.sensor.method.StartMethodTransformation;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;

public class LocationTransformerFactory
implements TransformerFactory {
    private static final String LOCATION_LISTENER = "android.location.LocationListener";
    private static final String ON_LOTION_CHANGED_DESCRIPTION = "(Landroid/location/Location;)V";
    private static final String DYNATRACE = "com.dynatrace.android.agent.Dynatrace";

    @Override
    public SubTransformer generateTransformer(ClassResolver classResolver) throws Exception {
        ArrayList<SensorGroup<MethodSensor>> sensors = new ArrayList<SensorGroup<MethodSensor>>();
        sensors.add(this.generateLocationListenerSensors(classResolver));
        return new DefaultSubTransformer("LocationTransformer", new ArrayList<SensorGroup<InstructionSensor>>(), sensors, classResolver);
    }

    private SensorGroup<MethodSensor> generateLocationListenerSensors(ClassResolver classResolver) {
        MethodInfo methodInfo = new MethodInfo("onLocationChanged", ON_LOTION_CHANGED_DESCRIPTION, 1025, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(classResolver.resolveClass(LOCATION_LISTENER), new MethodSensorImpl(methodInfo, new StartMethodTransformation(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash(DYNATRACE), "setGpsLocation", ON_LOTION_CHANGED_DESCRIPTION), ParameterInstructionProvider.withAllParameters(ON_LOTION_CHANGED_DESCRIPTION))));
    }
}

