/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.compose.ComposeClickTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.ComposeCombinedClickTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.ComposeToggleTransformation;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import java.util.ArrayList;

public class ComposeTransformFactory
implements TransformerFactory {
    private static final String COMPOSE_CLICK_SOURCE = "androidx.compose.foundation.ClickableKt";
    private static final String COMPOSE_CLICK_FUNCTION_NAME = "clickable-O2vRcR0";
    private static final String COMPOSE_CLICK_DESCRIPTION = "(Landroidx/compose/ui/Modifier;Landroidx/compose/foundation/interaction/MutableInteractionSource;Landroidx/compose/foundation/Indication;ZLjava/lang/String;Landroidx/compose/ui/semantics/Role;Lkotlin/jvm/functions/Function0;)Landroidx/compose/ui/Modifier;";
    private static final String COMPOSE_TOGGLE_SOURCE = "androidx.compose.foundation.selection.ToggleableKt";
    private static final String COMPOSE_TOGGLE_FUNCTION_NAME = "toggleableImpl-3WzHGRc";
    private static final String COMPOSE_TOGGLE_DESCRIPTION = "(Landroidx/compose/ui/Modifier;Landroidx/compose/ui/state/ToggleableState;ZLandroidx/compose/ui/semantics/Role;Landroidx/compose/foundation/interaction/MutableInteractionSource;Landroidx/compose/foundation/Indication;Lkotlin/jvm/functions/Function0;)Landroidx/compose/ui/Modifier;";
    private static final String COMPOSE_COMBINED_CLICK_SOURCE = "androidx.compose.foundation.ClickableKt";
    private static final String COMPOSE_COMBINED_CLICK_FUNCTION_NAME = "combinedClickable-XVZzFYc";
    private static final String COMPOSE_COMBINED_CLICK_DESCRIPTION = "(Landroidx/compose/ui/Modifier;Landroidx/compose/foundation/interaction/MutableInteractionSource;Landroidx/compose/foundation/Indication;ZLjava/lang/String;Landroidx/compose/ui/semantics/Role;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Landroidx/compose/ui/Modifier;";

    @Override
    public SubTransformer generateTransformer(ClassResolver classResolver) throws Exception {
        ArrayList<SensorGroup<MethodSensor>> sensors = new ArrayList<SensorGroup<MethodSensor>>();
        sensors.add(this.generateClickableSensor());
        sensors.add(this.generateToggleableSensor());
        sensors.add(this.generateCombinedClickableSensor());
        return new DefaultSubTransformer("ComposeTransformer", new ArrayList<SensorGroup<InstructionSensor>>(), sensors, classResolver);
    }

    private SensorGroup<MethodSensor> generateClickableSensor() {
        MethodInfo methodInfo = new MethodInfo(COMPOSE_CLICK_FUNCTION_NAME, COMPOSE_CLICK_DESCRIPTION, 25, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> "androidx.compose.foundation.ClickableKt".equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeClickTransformation()));
    }

    private SensorGroup<MethodSensor> generateToggleableSensor() {
        MethodInfo methodInfo = new MethodInfo(COMPOSE_TOGGLE_FUNCTION_NAME, COMPOSE_TOGGLE_DESCRIPTION, 25, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> COMPOSE_TOGGLE_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeToggleTransformation()));
    }

    private SensorGroup<MethodSensor> generateCombinedClickableSensor() {
        MethodInfo methodInfo = new MethodInfo(COMPOSE_COMBINED_CLICK_FUNCTION_NAME, COMPOSE_COMBINED_CLICK_DESCRIPTION, 25, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> "androidx.compose.foundation.ClickableKt".equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeCombinedClickTransformation()));
    }
}

