/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.filter.ClassLevelFilter;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.ReplaceInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.sensor.method.StartMethodTransformation;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpTransformerFactory
implements TransformerFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)"OkHttpTransformerFactory");
    private static final String CALL = "okhttp3.Call";
    private static final String CALLBACK = "okhttp3.Callback";
    private static final String CLIENT = "okhttp3.OkHttpClient";
    private static final String OK_URL_FACTORY = "okhttp3.OkUrlFactory";

    @Override
    public SubTransformer generateTransformer(ClassResolver classResolver) throws Exception {
        SensorGroup<InstructionSensor> callSensors = this.generateCallSensors(classResolver);
        ArrayList<SensorGroup<MethodSensor>> methodSensors = new ArrayList<SensorGroup<MethodSensor>>();
        methodSensors.add(this.generateCallbackSensors(classResolver));
        methodSensors.add(this.generateOkHttpClientSensors());
        ArrayList<SensorGroup<InstructionSensor>> instructionSensors = new ArrayList<SensorGroup<InstructionSensor>>();
        instructionSensors.add(callSensors);
        return new DefaultSubTransformer("OkHttp3Transformer", instructionSensors, methodSensors, classResolver);
    }

    @Override
    public List<String> mandatoryClasses() {
        return Collections.singletonList(CLIENT);
    }

    @Override
    public List<ClassLevelFilter> excludeClassFiles() {
        return Collections.singletonList(className -> className.startsWith("okhttp3.") && !className.startsWith(OK_URL_FACTORY));
    }

    private SensorGroup<InstructionSensor> generateCallSensors(ClassResolver classResolver) {
        return new SensorGroupImpl<InstructionSensor>(classResolver.resolveClass(CALL), new ReplaceInstructionSensor(MethodInstruction.createInterfaceMethodInstruction(Utils.dotToSlash(CALL), "execute", "()Lokhttp3/Response;"), MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.OkCallback"), "execute", "(Lokhttp3/Call;)Lokhttp3/Response;")), new ReplaceInstructionSensor(MethodInstruction.createInterfaceMethodInstruction(Utils.dotToSlash(CALL), "enqueue", "(Lokhttp3/Callback;)V"), MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.OkCallback"), "enqueue", "(Lokhttp3/Call;Lokhttp3/Callback;)V")));
    }

    private SensorGroup<MethodSensor> generateCallbackSensors(ClassResolver classResolver) {
        MethodInfo onResponseMethodInfo = new MethodInfo("onResponse", "(Lokhttp3/Call;Lokhttp3/Response;)V", 1025, null, new ArrayList<String>());
        MethodInfo onFailureMethodInfo = new MethodInfo("onFailure", "(Lokhttp3/Call;Ljava/io/IOException;)V", 1025, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(classResolver.resolveClass(CALLBACK), new MethodSensorImpl(onResponseMethodInfo, MethodSensorImpl.generateDefaultMethodTransformer(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.OkCallback"), "onResponse_ENTER", "(Lokhttp3/Call;Lokhttp3/Response;)V"), MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.OkCallback"), "onResponse_EXIT", "()V"))), new MethodSensorImpl(onFailureMethodInfo, MethodSensorImpl.generateDefaultMethodTransformer(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.OkCallback"), "onFailure_ENTER", "(Lokhttp3/Call;Ljava/io/IOException;)V"), MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.OkCallback"), "onFailure_EXIT", "()V"))));
    }

    private SensorGroup<MethodSensor> generateOkHttpClientSensors() {
        MethodInfo methodInfo = new MethodInfo("<init>", "(Lokhttp3/OkHttpClient$Builder;)V", 0, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> CLIENT.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new StartMethodTransformation(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.OkCallback"), "newInstance_START", "(Lokhttp3/OkHttpClient$Builder;)V"), ParameterInstructionProvider.withAllParameters("(Lokhttp3/OkHttpClient$Builder;)V"))));
    }
}

