/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.ExitMethodTransformation;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.sensor.method.StartMethodTransformation;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserActionTransformerFactory
implements TransformerFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)"UserActionTransformerFactory");
    private static final String ON_CLICK_LISTENER = "android.view.View$OnClickListener";
    private static final String ON_ITEM_CLICK_LISTENER = "android.widget.AdapterView$OnItemClickListener";
    private static final String ON_ITEM_SELECTED_LISTENER = "android.widget.AdapterView$OnItemSelectedListener";
    private static final String ON_MENU_ITEM_CLICK_LISTENER = "android.view.MenuItem$OnMenuItemClickListener";
    private static final String ON_PAGE_CHANGE_LISTENER_SUPPORT = "android.support.v4.view.ViewPager$OnPageChangeListener";
    private static final String ON_REFRESH_LISTENER_SUPPORT = "android.support.v4.widget.SwipeRefreshLayout$OnRefreshListener";
    private static final String ON_PAGE_CHANGE_LISTENER_ANDROID_X = "androidx.viewpager.widget.ViewPager$OnPageChangeListener";
    private static final String ON_REFRESH_LISTENER_ANDROID_X = "androidx.swiperefreshlayout.widget.SwipeRefreshLayout$OnRefreshListener";
    private static final String ACTIVITY = "android.app.Activity";
    private final Sensors sensors;

    public UserActionTransformerFactory(Sensors sensors) {
        this.sensors = sensors;
    }

    private static ParameterInstructionProvider generateAdapterViewParameters() {
        return ParameterInstructionProvider.withCustomParameter(25, 1).andThen(ParameterInstructionProvider.withCustomParameter(21, 2));
    }

    private static MethodTransformation[] generateAdapterViewMethodSensor(MethodInstruction startSensorMethod, MethodInstruction exitSensorMethod) {
        MethodTransformation[] methodTransformations = new MethodTransformation[]{new ExitMethodTransformation(exitSensorMethod, null), new StartMethodTransformation(startSensorMethod, UserActionTransformerFactory.generateAdapterViewParameters())};
        return methodTransformations;
    }

    @Override
    public SubTransformer generateTransformer(ClassResolver classResolver) throws Exception {
        ArrayList<SensorGroup<MethodSensor>> methodSensors = new ArrayList<SensorGroup<MethodSensor>>();
        if (this.sensors.onClickListener) {
            methodSensors.add(this.generateOnClickListenerSensors(classResolver));
        }
        if (this.sensors.onItemClickListener) {
            methodSensors.add(this.generateOnItemClickListenerSensors(classResolver));
        }
        if (this.sensors.onItemSelectedListener) {
            methodSensors.add(this.generateOnItemSelectedListenerSensors(classResolver));
        }
        if (this.sensors.onMenuItemClickListener) {
            methodSensors.add(this.generateOnMenuItemClickListenerSensors(classResolver));
        }
        if (this.sensors.onOptionsItemSelected) {
            methodSensors.add(this.generateActivitySensors(classResolver));
        }
        if (this.sensors.onPageChangeListener) {
            methodSensors.add(this.generateOnPageChangeListenerAndroidXSensors(classResolver));
            methodSensors.add(this.generateOnPageChangeListenerSupportSensors(classResolver));
        }
        if (this.sensors.onRefreshListener) {
            methodSensors.add(this.generateOnRefreshListenerAndroidXSensors(classResolver));
            methodSensors.add(this.generateOnRefreshListenerSupportSensors(classResolver));
        }
        return new DefaultSubTransformer("UserActionTransformer", new ArrayList<SensorGroup<InstructionSensor>>(), methodSensors, classResolver);
    }

    private SensorGroup<MethodSensor> generateOnClickListenerSensors(ClassResolver classResolver) {
        MethodInfo methodInfo = new MethodInfo("onClick", "(Landroid/view/View;)V", 1025, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(classResolver.resolveClass(ON_CLICK_LISTENER), new MethodSensorImpl(methodInfo, MethodSensorImpl.generateDefaultMethodTransformer(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.Callback"), "onClick_ENTER", "(Landroid/view/View;)V"), MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.Callback"), "onClick_EXIT", "()V"))));
    }

    private SensorGroup<MethodSensor> generateOnItemClickListenerSensors(ClassResolver classResolver) {
        MethodInfo methodInfo = new MethodInfo("onItemClick", "(Landroid/widget/AdapterView;Landroid/view/View;IJ)V", 1025, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(classResolver.resolveClass(ON_ITEM_CLICK_LISTENER), new MethodSensorImpl(methodInfo, UserActionTransformerFactory.generateAdapterViewMethodSensor(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.Callback"), "onItemClick_ENTER", "(Landroid/view/View;I)V"), MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.Callback"), "onItemClick_EXIT", "()V"))));
    }

    private SensorGroup<MethodSensor> generateOnItemSelectedListenerSensors(ClassResolver classResolver) {
        MethodInfo methodInfo = new MethodInfo("onItemSelected", "(Landroid/widget/AdapterView;Landroid/view/View;IJ)V", 1025, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(classResolver.resolveClass(ON_ITEM_SELECTED_LISTENER), new MethodSensorImpl(methodInfo, UserActionTransformerFactory.generateAdapterViewMethodSensor(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.Callback"), "onItemSelected_ENTER", "(Landroid/view/View;I)V"), MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.Callback"), "onItemSelected_EXIT", "()V"))));
    }

    private SensorGroup<MethodSensor> generateOnMenuItemClickListenerSensors(ClassResolver classResolver) {
        MethodInfo methodInfo = new MethodInfo("onMenuItemClick", "(Landroid/view/MenuItem;)Z", 1025, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(classResolver.resolveClass(ON_MENU_ITEM_CLICK_LISTENER), new MethodSensorImpl(methodInfo, MethodSensorImpl.generateDefaultMethodTransformer(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.Callback"), "onMenuItemClick_ENTER", "(Landroid/view/MenuItem;)V"), MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.Callback"), "onMenuItemClick_EXIT", "()V"))));
    }

    private SensorGroup<MethodSensor> generateActivitySensors(ClassResolver classResolver) {
        MethodInfo methodInfo = new MethodInfo("onOptionsItemSelected", "(Landroid/view/MenuItem;)Z", 1025, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(classResolver.resolveClass(ACTIVITY), new MethodSensorImpl(methodInfo, MethodSensorImpl.generateDefaultMethodTransformer(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.Callback"), "onOptionsItemSelected_ENTER", "(Landroid/view/MenuItem;)V"), MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.Callback"), "onOptionsItemSelected_EXIT", "()V"))));
    }

    private SensorGroup<MethodSensor> generateOnPageChangeListenerSupportSensors(ClassResolver classResolver) {
        MethodInfo methodInfo = new MethodInfo("onPageSelected", "(I)V", 1025, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(classResolver.resolveClass(ON_PAGE_CHANGE_LISTENER_SUPPORT), new MethodSensorImpl(methodInfo, MethodSensorImpl.generateDefaultMethodTransformer(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.Callback"), "onPageSelected_ENTER", "(I)V"), MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.Callback"), "onPageSelected_EXIT", "()V"))));
    }

    private SensorGroup<MethodSensor> generateOnRefreshListenerSupportSensors(ClassResolver classResolver) {
        MethodInfo methodInfo = new MethodInfo("onRefresh", "()V", 1025, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(classResolver.resolveClass(ON_REFRESH_LISTENER_SUPPORT), new MethodSensorImpl(methodInfo, MethodSensorImpl.generateDefaultMethodTransformer(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.Callback"), "onRefresh_ENTER", "()V"), MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.Callback"), "onRefresh_EXIT", "()V"))));
    }

    private SensorGroup<MethodSensor> generateOnPageChangeListenerAndroidXSensors(ClassResolver classResolver) {
        MethodInfo methodInfo = new MethodInfo("onPageSelected", "(I)V", 1025, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(classResolver.resolveClass(ON_PAGE_CHANGE_LISTENER_ANDROID_X), new MethodSensorImpl(methodInfo, MethodSensorImpl.generateDefaultMethodTransformer(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.Callback"), "onPageSelected_ENTER", "(I)V"), MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.Callback"), "onPageSelected_EXIT", "()V"))));
    }

    private SensorGroup<MethodSensor> generateOnRefreshListenerAndroidXSensors(ClassResolver classResolver) {
        MethodInfo methodInfo = new MethodInfo("onRefresh", "()V", 1025, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(classResolver.resolveClass(ON_REFRESH_LISTENER_ANDROID_X), new MethodSensorImpl(methodInfo, MethodSensorImpl.generateDefaultMethodTransformer(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.Callback"), "onRefresh_ENTER", "()V"), MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.Callback"), "onRefresh_EXIT", "()V"))));
    }

    public static class Sensors
    implements Serializable {
        private final boolean onClickListener;
        private final boolean onItemClickListener;
        private final boolean onItemSelectedListener;
        private final boolean onMenuItemClickListener;
        private final boolean onPageChangeListener;
        private final boolean onRefreshListener;
        private final boolean onOptionsItemSelected;

        private Sensors(boolean onClickListener, boolean onItemClickListener, boolean onItemSelectedListener, boolean onMenuItemClickListener, boolean onPageChangeListener, boolean onRefreshListener, boolean onOptionsItemSelected) {
            this.onClickListener = onClickListener;
            this.onItemClickListener = onItemClickListener;
            this.onItemSelectedListener = onItemSelectedListener;
            this.onMenuItemClickListener = onMenuItemClickListener;
            this.onPageChangeListener = onPageChangeListener;
            this.onRefreshListener = onRefreshListener;
            this.onOptionsItemSelected = onOptionsItemSelected;
        }

        public static Sensors allSensorsActivated() {
            return new Builder().withOnClickListener(true).withOnItemClickListener(true).withOnItemSelectedListener(true).withOnMenuItemClickListener(true).withOnPageChangeListener(true).withOnRefreshListener(true).withOnOptionsItemSelected(true).build();
        }

        public static class Builder {
            private boolean onClickListener = false;
            private boolean onItemClickListener = false;
            private boolean onItemSelectedListener = false;
            private boolean onMenuItemClickListener = false;
            private boolean onPageChangeListener = false;
            private boolean onRefreshListener = false;
            private boolean onOptionsItemSelected = false;

            public Builder withOnClickListener(boolean onClickListener) {
                this.onClickListener = onClickListener;
                return this;
            }

            public Builder withOnItemClickListener(boolean onItemClickListener) {
                this.onItemClickListener = onItemClickListener;
                return this;
            }

            public Builder withOnItemSelectedListener(boolean onItemSelectedListener) {
                this.onItemSelectedListener = onItemSelectedListener;
                return this;
            }

            public Builder withOnMenuItemClickListener(boolean onMenuItemClickListener) {
                this.onMenuItemClickListener = onMenuItemClickListener;
                return this;
            }

            public Builder withOnPageChangeListener(boolean onPageChangeListener) {
                this.onPageChangeListener = onPageChangeListener;
                return this;
            }

            public Builder withOnRefreshListener(boolean onRefreshListener) {
                this.onRefreshListener = onRefreshListener;
                return this;
            }

            public Builder withOnOptionsItemSelected(boolean onOptionsItemSelected) {
                this.onOptionsItemSelected = onOptionsItemSelected;
                return this;
            }

            public Sensors build() {
                return new Sensors(this.onClickListener, this.onItemClickListener, this.onItemSelectedListener, this.onMenuItemClickListener, this.onPageChangeListener, this.onRefreshListener, this.onOptionsItemSelected);
            }
        }
    }
}

