/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.instrumentor;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.UnknownLambdaTagException;
import com.dynatrace.android.instrumentation.filter.ExclusionManager;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.UnableToInstrumentException;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.util.LambdaConverterData;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambdaInstrumentor {
    private static final String CLASS_LAMBDA_METAFACTORY = "java/lang/invoke/LambdaMetafactory";
    private static final String METHOD_LAMBDA_METAFACTORY = "metafactory";
    private static final String DESC_LAMBDA_METAFACTORY = "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;";
    private static final Logger logger = LoggerFactory.getLogger((String)"LambdaInstrumentor");
    private static final int MAX_LENGTH_METHOD_NAME = 65536;
    private static final List<String> KNOWN_INSTRUCTIONS = Arrays.asList("java/lang/invoke/StringConcatFactory.makeConcat", "java/lang/invoke/StringConcatFactory.makeConcatWithConstants");
    private final ClassResolver classResolver;
    private final List<SensorGroup<InstructionSensor>> instructionTransformers;
    private final List<SensorGroup<MethodSensor>> methodSensors;

    public LambdaInstrumentor(ClassResolver classResolver, List<SensorGroup<InstructionSensor>> instructionTransformers, List<SensorGroup<MethodSensor>> methodSensors) {
        this.instructionTransformers = instructionTransformers;
        this.methodSensors = methodSensors;
        this.classResolver = classResolver;
    }

    public boolean transformMethod(ClassNode classNode, MethodNode method, ExclusionManager exclusionManager) {
        ArrayList<InvokeDynamicInsnNode> lambdaInstructions = new ArrayList<InvokeDynamicInsnNode>();
        for (AbstractInsnNode instruction : method.instructions) {
            if (!(instruction instanceof InvokeDynamicInsnNode)) continue;
            lambdaInstructions.add((InvokeDynamicInsnNode)instruction);
        }
        boolean modified = false;
        int count = 0;
        for (InvokeDynamicInsnNode node : lambdaInstructions) {
            if (node.bsm.getOwner().equals(CLASS_LAMBDA_METAFACTORY) && node.bsm.getName().equals(METHOD_LAMBDA_METAFACTORY) && node.bsm.getDesc().equals(DESC_LAMBDA_METAFACTORY) && node.bsmArgs.length == 3) {
                String methodName = method.name.equals("<init>") ? "new" : (method.name.equals("<clinit>") ? "static" : method.name);
                String desc = method.desc.replaceAll("[.;\\[/()]", "-");
                String newMethodName = "instrumented$" + count + "$" + methodName + "$" + desc;
                if (newMethodName.length() >= 65536) {
                    throw new UnableToInstrumentException("exceeded max length for method name " + newMethodName);
                }
                ++count;
                modified |= this.instrumentLambda(node, newMethodName, classNode, exclusionManager);
                continue;
            }
            if (KNOWN_INSTRUCTIONS.contains(node.bsm.getOwner() + "." + node.bsm.getName())) continue;
            logger.info("found unknown invokedynamic instruction: owner={} name={} desc={} in {}#{}", new Object[]{node.bsm.getOwner(), node.bsm.getName(), node.bsm.getDesc(), Utils.slashToDot(classNode.name), method.name});
        }
        return modified;
    }

    private boolean instrumentLambda(InvokeDynamicInsnNode node, String newMethodName, ClassNode classNode, ExclusionManager exclusionManager) {
        LambdaConverterData trampolineData;
        Type instantiatedMethodType;
        Handle methodHandle;
        Type samMethodType;
        try {
            samMethodType = (Type)node.bsmArgs[0];
            methodHandle = (Handle)node.bsmArgs[1];
            instantiatedMethodType = (Type)node.bsmArgs[2];
        }
        catch (ClassCastException e) {
            logger.info("unknown/invalid lambda bootstrap method in {}", (Object)Utils.slashToDot(classNode.name), (Object)e);
            return false;
        }
        Optional<InstructionSensor> instrTransformer = this.findInstructionTransformer(methodHandle, exclusionManager);
        List<MethodSensor> methodTransformers = this.findMethodTransformers(node, samMethodType);
        if (!instrTransformer.isPresent() && methodTransformers.isEmpty()) {
            return false;
        }
        try {
            trampolineData = this.addTrampolineMethod(classNode, node, newMethodName, methodHandle, instantiatedMethodType);
        }
        catch (UnknownLambdaTagException e) {
            logger.info("unknown invokedynamic node", (Throwable)e);
            return false;
        }
        instrTransformer.ifPresent(instructionSensor -> instructionSensor.transform(trampolineData.methodNode, trampolineData.methodInsnNode));
        MethodNode trampolineNode = trampolineData.methodNode;
        int index = (Type.getType((String)trampolineNode.desc).getArgumentsAndReturnSizes() >> 2) - (instantiatedMethodType.getArgumentsAndReturnSizes() >> 2);
        for (MethodSensor methodSensor : methodTransformers) {
            methodSensor.transformMethod(trampolineNode, index);
        }
        return true;
    }

    private Optional<InstructionSensor> findInstructionTransformer(Handle methodHandle, ExclusionManager exclusionManager) {
        ClassInfo classInfo;
        String className = Type.getObjectType((String)methodHandle.getOwner()).getClassName();
        if (exclusionManager.filterInvokeInstruction(className, methodHandle.getName(), methodHandle.getDesc())) {
            logger.debug("exclude method handle {}#{}{}", new Object[]{className, methodHandle.getName(), methodHandle.getDesc()});
            return Optional.empty();
        }
        try {
            classInfo = this.classResolver.resolveClass(className);
        }
        catch (Throwable t) {
            logger.info("skip instruction with unknown method call {}#{}{}, {}", new Object[]{className, methodHandle.getName(), methodHandle.getDesc(), t.toString()});
            throw t;
        }
        return this.instructionTransformers.stream().filter(sensorGroup -> sensorGroup.matchClass(classInfo)).flatMap(sensorGroup -> sensorGroup.getSensors().stream()).filter(sensor -> sensor.matchInstruction(classInfo, methodHandle.getName(), methodHandle.getDesc())).findAny();
    }

    private List<MethodSensor> findMethodTransformers(InvokeDynamicInsnNode node, Type type) {
        ClassInfo classInfo;
        Type methodType = Type.getType((String)node.desc);
        String className = methodType.getReturnType().getClassName();
        try {
            classInfo = this.classResolver.resolveClass(className);
        }
        catch (Throwable t) {
            logger.info("skip unknown NameAndType: type={} name={}, {}", new Object[]{node.desc, node.name, t.toString()});
            throw t;
        }
        return this.methodSensors.stream().filter(sensorGroup -> sensorGroup.matchClass(classInfo)).flatMap(sensorGroup -> sensorGroup.getSensors().stream()).filter(sensor -> sensor.matchMethod(classInfo, node.name, type.getDescriptor(), true)).collect(Collectors.toList());
    }

    private LambdaConverterData addTrampolineMethod(ClassNode classNode, InvokeDynamicInsnNode node, String newMethodName, Handle methodHandle, Type type) throws UnknownLambdaTagException {
        Type methodType = Type.getType((String)node.desc);
        String lambdaClassName = methodType.getReturnType().getClassName();
        String className = Type.getObjectType((String)methodHandle.getOwner()).getClassName();
        if (logger.isDebugEnabled()) {
            logger.debug("Detected lambda for method {}#{}{} in class {}. Instrument bootstrap method with method call {}#{}{}", new Object[]{lambdaClassName, node.name, type.getDescriptor(), Utils.slashToDot(classNode.name), className, methodHandle.getName(), methodHandle.getDesc()});
        }
        LambdaConverterData data = Utils.extractLambdaIntoExtraMethod(newMethodName, methodHandle, type, methodType.getArgumentTypes());
        MethodNode trampolineNode = data.methodNode;
        logger.debug("New method {}#{}{} created in {}", new Object[]{lambdaClassName, trampolineNode.name, trampolineNode.desc, Utils.slashToDot(classNode.name)});
        classNode.methods.add(trampolineNode);
        node.bsmArgs[1] = new Handle(6, classNode.name, newMethodName, trampolineNode.desc, false);
        return data;
    }
}

