/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import com.dynatrace.tools.android.AgpVersionUtil;
import com.dynatrace.tools.android.DependencyProducer;
import com.dynatrace.tools.android.InstrumentationPlugin;
import com.dynatrace.tools.android.LegacyInstrumentationPlugin;
import com.dynatrace.tools.android.dsl.DynatraceExtension;
import com.dynatrace.tools.android.util.Utils;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.plugins.PluginManager;
import org.gradle.internal.reflect.Instantiator;

public class DynatracePlugin
implements Plugin<Project> {
    private static final String IGNORE_BUILD_WARNING = "dynatrace.ignoreBuildWarning";
    private static final String ERROR_MSG = " If you are sure that the plugin is applied correctly, you can deactivate the build checks with the Gradle project property '-Pdynatrace.ignoreBuildWarning=true'.";
    private final Instantiator instantiator;
    private final AtomicBoolean isApplicationPluginApplied = new AtomicBoolean(false);

    @Inject
    public DynatracePlugin(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public static String agentDependency() {
        return DependencyProducer.mobileAgent();
    }

    static DynatraceExtension createExtension(Project project, Instantiator instantiator) {
        return (DynatraceExtension)project.getExtensions().create("dynatrace", DynatraceExtension.class, new Object[]{project, instantiator});
    }

    public void apply(Project project) {
        Utils.verifyGradleVersion();
        if (Utils.isOldPluginApplied()) {
            throw new GradleException("Your build script classpath also contains an older version of the Dynatrace Android Gradle plugin. You must remove the old version from your build script classpath.");
        }
        boolean ignoreBuildWarning = Boolean.parseBoolean((String)project.findProperty(IGNORE_BUILD_WARNING));
        if (!ignoreBuildWarning) {
            if (project != project.getRootProject()) {
                throw new GradleException("The Dynatrace Android Gradle plugin must be applied in the top-level build.gradle (or build.gradle.kts) file. If you are sure that the plugin is applied correctly, you can deactivate the build checks with the Gradle project property '-Pdynatrace.ignoreBuildWarning=true'.");
            }
            Action cancelBuildAction = appliedPlugin -> {
                throw new GradleException("The Dynatrace Android Gradle plugin can't be directly applied to a Java- or Android-related module. It must be applied in the top-level build.gradle (or build.gradle.kts) file (see https://developer.android.com/studio/build#build-files ). If you are sure that the plugin is applied correctly, you can deactivate the build checks with the Gradle project property '-Pdynatrace.ignoreBuildWarning=true'.");
            };
            this.detectCommonModules(project.getPluginManager(), (Action<AppliedPlugin>)cancelBuildAction);
        }
        DynatracePlugin.createExtension(project, this.instantiator);
        Action applyPluginAction = AgpVersionUtil.isAndroidPluginVersionAvailable() ? objectConfigurationAction -> objectConfigurationAction.plugin(InstrumentationPlugin.class) : objectConfigurationAction -> objectConfigurationAction.plugin(LegacyInstrumentationPlugin.class);
        project.subprojects(subproject -> {
            Action appliedPluginAction = appliedPlugin -> {
                subproject.apply(applyPluginAction);
                this.isApplicationPluginApplied.set(true);
            };
            subproject.getPluginManager().withPlugin("com.android.application", appliedPluginAction);
            subproject.getPluginManager().withPlugin("com.android.dynamic-feature", appliedPlugin -> subproject.apply(applyPluginAction));
        });
        project.getGradle().addBuildListener((BuildListener)new VerifyApplicationModuleListener());
    }

    private void detectCommonModules(PluginManager pluginmanager, Action<AppliedPlugin> appliedPluginAction) {
        pluginmanager.withPlugin("com.android.application", appliedPluginAction);
        pluginmanager.withPlugin("com.android.library", appliedPluginAction);
        pluginmanager.withPlugin("com.android.dynamic-feature", appliedPluginAction);
        this.detectInstantAppModules(pluginmanager, appliedPluginAction);
        pluginmanager.withPlugin("java-library", appliedPluginAction);
    }

    @Deprecated
    private void detectInstantAppModules(PluginManager pluginmanager, Action<AppliedPlugin> appliedPluginAction) {
        pluginmanager.withPlugin("com.android.instantapp", appliedPluginAction);
        pluginmanager.withPlugin("com.android.feature", appliedPluginAction);
    }

    private class VerifyApplicationModuleListener
    implements BuildListener {
        private VerifyApplicationModuleListener() {
        }

        public void projectsEvaluated(Gradle gradle) {
            if (!DynatracePlugin.this.isApplicationPluginApplied.get()) {
                throw new GradleException("The Dynatrace Android Gradle Plugin can only be applied to Android application projects");
            }
        }

        public void settingsEvaluated(Settings settings) {
        }

        public void projectsLoaded(Gradle gradle) {
        }

        public void buildFinished(BuildResult buildResult) {
        }
    }
}

