/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.instruction;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.UnableToInstrumentException;
import java.util.function.Function;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class InsertBeforeInstructionSensor
implements InstructionSensor {
    private static final int MAX_LOCALS = 65536;
    private final MethodInstruction origMethod;
    private final Type type;
    private final Function<Integer, InsnList> instructionFactory;

    public InsertBeforeInstructionSensor(MethodInstruction origMethod, MethodInstruction instrMethod) {
        this(origMethod, new CallbackWithAllStackValuesFactory(instrMethod));
    }

    public InsertBeforeInstructionSensor(MethodInstruction origMethod, Function<Integer, InsnList> instructionFactory) {
        this.origMethod = origMethod;
        this.type = Type.getType((String)origMethod.getMethodDescriptor());
        this.instructionFactory = instructionFactory;
    }

    private static void preserveStackValue(MethodNode methodNode, InsnList instructions, Type paramType) {
        if (methodNode.maxLocals + paramType.getSize() >= 65536) {
            throw new UnableToInstrumentException("exceeded max value for locals from method " + methodNode.name + " " + methodNode.desc);
        }
        VarInsnNode storeInstr = new VarInsnNode(paramType.getOpcode(54), methodNode.maxLocals);
        instructions.insert((AbstractInsnNode)storeInstr);
        VarInsnNode loadInstr = new VarInsnNode(paramType.getOpcode(21), methodNode.maxLocals);
        instructions.add((AbstractInsnNode)loadInstr);
        methodNode.maxLocals += paramType.getSize();
    }

    @Override
    public boolean matchInstruction(ClassInfo owner, String methodName, String desc) {
        return methodName.equals(this.origMethod.getMethodName()) && desc.equals(this.type.getDescriptor());
    }

    @Override
    public void transform(MethodNode methodNode, MethodInsnNode methodInsnNode) {
        InsnList instructions = new InsnList();
        int startParameterIndex = methodNode.maxLocals;
        AbstractInsnNode firstLoadInstr = null;
        if (this.origMethod.getOpcode() != 184) {
            InsertBeforeInstructionSensor.preserveStackValue(methodNode, instructions, Type.getObjectType((String)this.origMethod.getClassName()));
            firstLoadInstr = instructions.getLast();
        }
        for (Type paramType : this.type.getArgumentTypes()) {
            InsertBeforeInstructionSensor.preserveStackValue(methodNode, instructions, paramType);
            if (firstLoadInstr != null) continue;
            firstLoadInstr = instructions.getLast();
        }
        if (firstLoadInstr == null) {
            firstLoadInstr = methodInsnNode;
        } else {
            methodNode.instructions.insertBefore((AbstractInsnNode)methodInsnNode, instructions);
        }
        methodNode.instructions.insertBefore(firstLoadInstr, this.instructionFactory.apply(startParameterIndex));
    }

    static class CallbackWithAllStackValuesFactory
    implements Function<Integer, InsnList> {
        private final MethodInstruction instrMethod;

        CallbackWithAllStackValuesFactory(MethodInstruction instrMethod) {
            this.instrMethod = instrMethod;
        }

        @Override
        public InsnList apply(Integer startParameterIndex) {
            Type methodType = Type.getType((String)this.instrMethod.getMethodDescriptor());
            InsnList instructions = new InsnList();
            int slotCount = startParameterIndex;
            for (Type paramType : methodType.getArgumentTypes()) {
                instructions.add((AbstractInsnNode)new VarInsnNode(paramType.getOpcode(21), slotCount));
                slotCount += paramType.getSize();
            }
            String instrOwner = this.instrMethod.getClassName();
            String instrMethodName = this.instrMethod.getMethodName();
            String instrDesc = this.instrMethod.getMethodDescriptor();
            instructions.add((AbstractInsnNode)new MethodInsnNode(184, instrOwner, instrMethodName, instrDesc, false));
            return instructions;
        }
    }
}

