/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.compose.ComposeAccessibilityNodeTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.ComposeCheckboxTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.ComposeClickTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.ComposeCombinedClickTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.ComposeNodeTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.ComposeSwipeTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.ComposeToggleO2vRcR0Transformation;
import com.dynatrace.android.instrumentation.sensor.compose.ComposeTriToggleO2vRcR0Transformation;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import java.util.ArrayList;

public class ComposeTransformFactory
implements TransformerFactory {
    private static final String CLICK_SOURCE = "androidx.compose.foundation.ClickableKt";
    private static final String CLICK_FUNCTION_NAME = "clickable-O2vRcR0";
    private static final String CLICK_DESCRIPTION = "(Landroidx/compose/ui/Modifier;Landroidx/compose/foundation/interaction/MutableInteractionSource;Landroidx/compose/foundation/Indication;ZLjava/lang/String;Landroidx/compose/ui/semantics/Role;Lkotlin/jvm/functions/Function0;)Landroidx/compose/ui/Modifier;";
    private static final String COMBINED_CLICK_SOURCE = "androidx.compose.foundation.ClickableKt";
    private static final String COMBINED_CLICK_FUNCTION_NAME = "combinedClickable-XVZzFYc";
    private static final String COMBINED_CLICK_DESCRIPTION = "(Landroidx/compose/ui/Modifier;Landroidx/compose/foundation/interaction/MutableInteractionSource;Landroidx/compose/foundation/Indication;ZLjava/lang/String;Landroidx/compose/ui/semantics/Role;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Landroidx/compose/ui/Modifier;";
    private static final String CHECKBOX_SOURCE = "androidx.compose.material.CheckboxKt";
    private static final String CHECKBOX_FUNCTION_NAME = "Checkbox";
    private static final String CHECKBOX_DESCRIPTION = "(ZLkotlin/jvm/functions/Function1;Landroidx/compose/ui/Modifier;ZLandroidx/compose/foundation/interaction/MutableInteractionSource;Landroidx/compose/material/CheckboxColors;Landroidx/compose/runtime/Composer;II)V";
    private static final String TOGGLE_SOURCE = "androidx.compose.foundation.selection.ToggleableKt";
    private static final String TRI_TOGGLE_O2vRcR0_FUNCTION_NAME = "triStateToggleable-O2vRcR0";
    private static final String TRI_TOGGLE_O2vRcR0_DESCRIPTION = "(Landroidx/compose/ui/Modifier;Landroidx/compose/ui/state/ToggleableState;Landroidx/compose/foundation/interaction/MutableInteractionSource;Landroidx/compose/foundation/Indication;ZLandroidx/compose/ui/semantics/Role;Lkotlin/jvm/functions/Function0;)Landroidx/compose/ui/Modifier;";
    private static final String TOGGLE_O2vRcR0_FUNCTION_NAME = "toggleable-O2vRcR0";
    private static final String TOGGLE_O2vRcR0_DESCRIPTION = "(Landroidx/compose/ui/Modifier;ZLandroidx/compose/foundation/interaction/MutableInteractionSource;Landroidx/compose/foundation/Indication;ZLandroidx/compose/ui/semantics/Role;Lkotlin/jvm/functions/Function1;)Landroidx/compose/ui/Modifier;";
    private static final String SWIPE_SOURCE = "androidx.compose.material.SwipeableState";
    private static final String SWIPE_FUNCTION_NAME = "performFling";
    private static final String SWIPE_DESCRIPTION = "(FLkotlin/coroutines/Continuation;)Ljava/lang/Object;";
    private static final String NODE_SOURCE = "androidx.compose.ui.node.BackwardsCompatNode";
    private static final String NODE_FUNCTION_NAME = "onPointerEvent-H0pRuoY";
    private static final String NODE_DESCRIPTION = "(Landroidx/compose/ui/input/pointer/PointerEvent;Landroidx/compose/ui/input/pointer/PointerEventPass;J)V";
    private static final String ACCESSIBILITY_NODE_SOURCE = "androidx.compose.ui.platform.AndroidComposeViewAccessibilityDelegateCompat";
    private static final String ACCESSIBILITY_NODE_FUNCTION_NAME = "performActionHelper";
    private static final String ACCESSIBILITY_NODE_DESCRIPTION = "(IILandroid/os/Bundle;)Z";

    @Override
    public SubTransformer generateTransformer(ClassResolver classResolver) throws Exception {
        ArrayList<SensorGroup<MethodSensor>> sensors = new ArrayList<SensorGroup<MethodSensor>>();
        sensors.add(this.generateClickableSensor());
        sensors.add(this.generateCombinedClickableSensor());
        sensors.add(this.generateCheckboxSensor());
        sensors.add(this.generateTriToggleableO2vRcR0Sensor());
        sensors.add(this.generateToggleableO2vRcR0Sensor());
        sensors.add(this.generateSwipeableSensor());
        sensors.add(this.generateSemanticsNodeSensor());
        sensors.add(this.generateAccessibilitySemanticsNodeSensor());
        return new DefaultSubTransformer("ComposeTransformer", new ArrayList<SensorGroup<InstructionSensor>>(), sensors, classResolver);
    }

    private SensorGroup<MethodSensor> generateClickableSensor() {
        MethodInfo methodInfo = new MethodInfo(CLICK_FUNCTION_NAME, CLICK_DESCRIPTION, 25, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> "androidx.compose.foundation.ClickableKt".equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeClickTransformation()));
    }

    private SensorGroup<MethodSensor> generateCombinedClickableSensor() {
        MethodInfo methodInfo = new MethodInfo(COMBINED_CLICK_FUNCTION_NAME, COMBINED_CLICK_DESCRIPTION, 25, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> "androidx.compose.foundation.ClickableKt".equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeCombinedClickTransformation()));
    }

    private SensorGroup<MethodSensor> generateCheckboxSensor() {
        MethodInfo methodInfo = new MethodInfo(CHECKBOX_FUNCTION_NAME, CHECKBOX_DESCRIPTION, 25, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> CHECKBOX_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeCheckboxTransformation()));
    }

    private SensorGroup<MethodSensor> generateTriToggleableO2vRcR0Sensor() {
        MethodInfo methodInfo = new MethodInfo(TRI_TOGGLE_O2vRcR0_FUNCTION_NAME, TRI_TOGGLE_O2vRcR0_DESCRIPTION, 25, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> TOGGLE_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeTriToggleO2vRcR0Transformation()));
    }

    private SensorGroup<MethodSensor> generateToggleableO2vRcR0Sensor() {
        MethodInfo methodInfo = new MethodInfo(TOGGLE_O2vRcR0_FUNCTION_NAME, TOGGLE_O2vRcR0_DESCRIPTION, 25, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> TOGGLE_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeToggleO2vRcR0Transformation()));
    }

    private SensorGroup<MethodSensor> generateSwipeableSensor() {
        MethodInfo methodInfo = new MethodInfo(SWIPE_FUNCTION_NAME, SWIPE_DESCRIPTION, 17, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> SWIPE_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeSwipeTransformation()));
    }

    private SensorGroup<MethodSensor> generateSemanticsNodeSensor() {
        MethodInfo methodInfo = new MethodInfo(NODE_FUNCTION_NAME, NODE_DESCRIPTION, 1, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> NODE_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeNodeTransformation()));
    }

    private SensorGroup<MethodSensor> generateAccessibilitySemanticsNodeSensor() {
        MethodInfo methodInfo = new MethodInfo(ACCESSIBILITY_NODE_FUNCTION_NAME, ACCESSIBILITY_NODE_DESCRIPTION, 1, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> ACCESSIBILITY_NODE_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeAccessibilityNodeTransformation()));
    }
}

