/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InsertAfterInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientTransformerFactory
implements TransformerFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)"HttpClientTransformerFactory");
    private static final String HTTP_CLIENT = "org.apache.http.client.HttpClient";
    private static final String HTTP_REQUEST_BASE = "org.apache.http.client.methods.HttpRequestBase";

    @Override
    public SubTransformer generateTransformer(ClassResolver classResolver) throws Exception {
        ArrayList<SensorGroup<InstructionSensor>> instructionSensors = new ArrayList<SensorGroup<InstructionSensor>>();
        instructionSensors.add(this.generateHttpClientSensors(classResolver));
        instructionSensors.add(this.generateHttpRequestBaseSensors(classResolver));
        return new DefaultSubTransformer("HttpClientTransformer", instructionSensors, new ArrayList<SensorGroup<MethodSensor>>(), classResolver);
    }

    private SensorGroup<InstructionSensor> generateHttpRequestBaseSensors(ClassResolver classResolver) {
        return new SensorGroupImpl<InstructionSensor>(classResolver.resolveClass(HTTP_REQUEST_BASE), new InsertAfterInstructionSensor("<init>", instructions -> {
            instructions.add((AbstractInsnNode)new InsnNode(89));
            instructions.add((AbstractInsnNode)Utils.generateMethodInstructionNode(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.callback.HttpClientCallback"), "newInstance", "(Lorg/apache/http/client/methods/HttpRequestBase;)V")));
        }));
    }

    private SensorGroup<InstructionSensor> generateHttpClientSensors(ClassResolver classResolver) {
        return new SensorGroupImpl<InstructionSensor>(classResolver.resolveClass(HTTP_CLIENT), new InstructionSensorImpl((owner, methodName, desc) -> methodName.equals("execute"), (methodNode, methodInsnNode) -> {
            StringBuilder sb = new StringBuilder(methodInsnNode.desc);
            sb.insert(1, "Lorg/apache/http/client/HttpClient;");
            methodNode.instructions.set((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new MethodInsnNode(184, "com.dynatrace.android.callback.HttpClientCallback".replace('.', '/'), "execute", sb.toString(), false));
        }));
    }
}

