/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.manifest;

import com.dynatrace.tools.android.InstrumentationException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ManifestInstrumentor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ManifestInstrumentor");
    private static final String DT_APPLICATION_CLASS = "com.dynatrace.android.app.Application";
    private static final String ANDROID_APPLICATION_CLASS = "android.app.Application";
    private static final String KEY_ANDROID_APPLICATION = "android:name";
    private static final String REGEX = "(<application\\s*(?:\\w*(?::\\w*)?=\".*\"\\s)*\\s*android:name\\s*=\\s*)\"([\\w.]*)\"";
    private static final Pattern REGEX_PATTERN = Pattern.compile("(<application\\s*(?:\\w*(?::\\w*)?=\".*\"\\s)*\\s*android:name\\s*=\\s*)\"([\\w.]*)\"");

    public String instrumentManifest(String androidManifestXml) {
        Document doc;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            doc = docBuilder.parse(new InputSource(new StringReader(androidManifestXml)));
        }
        catch (Exception e) {
            throw new InstrumentationException("Failed to parse manifest XML", e);
        }
        NodeList applicationTags = doc.getElementsByTagName("application");
        if (applicationTags.getLength() != 1) {
            throw new InstrumentationException("Expected one application node but got " + applicationTags.getLength());
        }
        Node applicationTag = doc.getElementsByTagName("application").item(0);
        NamedNodeMap attributes = applicationTag.getAttributes();
        Node nameAttribute = attributes.getNamedItem(KEY_ANDROID_APPLICATION);
        if (nameAttribute == null) {
            LOGGER.debug("Inserting the Dynatrace application class into the Android manifest");
            return androidManifestXml.replaceAll("<application", "<application android:name=\"com.dynatrace.android.app.Application\" ");
        }
        if (ANDROID_APPLICATION_CLASS.equals(nameAttribute.getNodeValue())) {
            Matcher matcher = REGEX_PATTERN.matcher(androidManifestXml);
            if (matcher.find()) {
                LOGGER.debug("Replacing the existing Android application class with the Dynatrace application class in the Android manifest");
                return matcher.replaceAll("$1\"com.dynatrace.android.app.Application\"");
            }
            throw new InstrumentationException("Could not parse application tag in: " + androidManifestXml);
        }
        return androidManifestXml;
    }
}

