/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.compose.ComposeAccessibilityNodeTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.ComposeCheckboxTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.ComposeClickTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.ComposeCombinedClickTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.ComposeDependencyCheckerTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.ComposeNodeTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.ComposeSwipeTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.ComposeToggleTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.ComposeTriToggleTransformation;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ComposeTransformFactory
implements TransformerFactory {
    private static final String CLICK_SOURCE = "androidx.compose.foundation.ClickableKt";
    private static final String CLICK_FUNCTION_NAME = "clickable-O2vRcR0";
    private static final String CLICK_DESCRIPTION = "(Landroidx/compose/ui/Modifier;Landroidx/compose/foundation/interaction/MutableInteractionSource;Landroidx/compose/foundation/Indication;ZLjava/lang/String;Landroidx/compose/ui/semantics/Role;Lkotlin/jvm/functions/Function0;)Landroidx/compose/ui/Modifier;";
    private static final String COMBINED_CLICK_SOURCE = "androidx.compose.foundation.ClickableKt";
    private static final String COMBINED_CLICK_FUNCTION_NAME = "combinedClickable-XVZzFYc";
    private static final String COMBINED_CLICK_DESCRIPTION = "(Landroidx/compose/ui/Modifier;Landroidx/compose/foundation/interaction/MutableInteractionSource;Landroidx/compose/foundation/Indication;ZLjava/lang/String;Landroidx/compose/ui/semantics/Role;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Landroidx/compose/ui/Modifier;";
    private static final String CHECKBOX_SOURCE = "androidx.compose.material.CheckboxKt";
    private static final String CHECKBOX_FUNCTION_NAME = "Checkbox";
    private static final String CHECKBOX_DESCRIPTION = "(ZLkotlin/jvm/functions/Function1;Landroidx/compose/ui/Modifier;ZLandroidx/compose/foundation/interaction/MutableInteractionSource;Landroidx/compose/material/CheckboxColors;Landroidx/compose/runtime/Composer;II)V";
    private static final String TOGGLE_SOURCE = "androidx.compose.foundation.selection.ToggleableKt";
    private static final String TRI_TOGGLE_FUNCTION_NAME = "triStateToggleable-O2vRcR0";
    private static final String TRI_TOGGLE_DESCRIPTION = "(Landroidx/compose/ui/Modifier;Landroidx/compose/ui/state/ToggleableState;Landroidx/compose/foundation/interaction/MutableInteractionSource;Landroidx/compose/foundation/Indication;ZLandroidx/compose/ui/semantics/Role;Lkotlin/jvm/functions/Function0;)Landroidx/compose/ui/Modifier;";
    private static final String TOGGLE_FUNCTION_NAME = "toggleable-O2vRcR0";
    private static final String TOGGLE_DESCRIPTION = "(Landroidx/compose/ui/Modifier;ZLandroidx/compose/foundation/interaction/MutableInteractionSource;Landroidx/compose/foundation/Indication;ZLandroidx/compose/ui/semantics/Role;Lkotlin/jvm/functions/Function1;)Landroidx/compose/ui/Modifier;";
    private static final String SWIPE_SOURCE = "androidx.compose.material.SwipeableState";
    private static final String SWIPE_FUNCTION_NAME = "performFling";
    private static final String SWIPE_DESCRIPTION = "(FLkotlin/coroutines/Continuation;)Ljava/lang/Object;";
    private static final String NODE_SOURCE = "androidx.compose.ui.node.BackwardsCompatNode";
    private static final String NODE_FUNCTION_NAME = "onPointerEvent-H0pRuoY";
    private static final String NODE_DESCRIPTION = "(Landroidx/compose/ui/input/pointer/PointerEvent;Landroidx/compose/ui/input/pointer/PointerEventPass;J)V";
    private static final String ACCESSIBILITY_NODE_SOURCE = "androidx.compose.ui.platform.AndroidComposeViewAccessibilityDelegateCompat";
    private static final String ACCESSIBILITY_NODE_FUNCTION_NAME = "performActionHelper";
    private static final String ACCESSIBILITY_NODE_DESCRIPTION = "(IILandroid/os/Bundle;)Z";
    private static final String DEPENDENCY_SOURCE = "com.dynatrace.android.agent.conf.ComposeDependencyChecker";
    private static final String DEPENDENCY_FUNCTION_NAME = "hasComposeDependency";
    private static final String DEPENDENCY_FUNCTION_DESCRIPTION = "()Z";
    private final Sensors definedSensors;

    public ComposeTransformFactory(Sensors definedSensors) {
        this.definedSensors = definedSensors;
    }

    @Override
    public SubTransformer generateTransformer(ClassResolver classResolver) throws Exception {
        ArrayList<SensorGroup<MethodSensor>> sensors = new ArrayList<SensorGroup<MethodSensor>>();
        if (this.definedSensors.composeClickable) {
            sensors.add(this.generateClickableSensor());
            sensors.add(this.generateCombinedClickableSensor());
            sensors.add(this.generateCheckboxSensor());
            sensors.add(this.generateTriToggleableSensor());
            sensors.add(this.generateToggleableSensor());
        }
        if (this.definedSensors.composeSwipeable) {
            sensors.add(this.generateSwipeableSensor());
        }
        if (this.definedSensors.composeSemantics) {
            sensors.add(this.generateSemanticsNodeSensor());
            sensors.add(this.generateAccessibilitySemanticsNodeSensor());
        }
        sensors.add(this.generateDependencySensor());
        return new DefaultSubTransformer("ComposeTransformer", new ArrayList<SensorGroup<InstructionSensor>>(), sensors, classResolver);
    }

    private SensorGroup<MethodSensor> generateClickableSensor() {
        MethodInfo methodInfo = new MethodInfo(CLICK_FUNCTION_NAME, CLICK_DESCRIPTION, 25, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> "androidx.compose.foundation.ClickableKt".equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeClickTransformation()));
    }

    private SensorGroup<MethodSensor> generateCombinedClickableSensor() {
        MethodInfo methodInfo = new MethodInfo(COMBINED_CLICK_FUNCTION_NAME, COMBINED_CLICK_DESCRIPTION, 25, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> "androidx.compose.foundation.ClickableKt".equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeCombinedClickTransformation()));
    }

    private SensorGroup<MethodSensor> generateCheckboxSensor() {
        MethodInfo methodInfo = new MethodInfo(CHECKBOX_FUNCTION_NAME, CHECKBOX_DESCRIPTION, 25, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> CHECKBOX_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeCheckboxTransformation()));
    }

    private SensorGroup<MethodSensor> generateTriToggleableSensor() {
        MethodInfo methodInfo = new MethodInfo(TRI_TOGGLE_FUNCTION_NAME, TRI_TOGGLE_DESCRIPTION, 25, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> TOGGLE_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeTriToggleTransformation()));
    }

    private SensorGroup<MethodSensor> generateToggleableSensor() {
        MethodInfo methodInfo = new MethodInfo(TOGGLE_FUNCTION_NAME, TOGGLE_DESCRIPTION, 25, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> TOGGLE_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeToggleTransformation()));
    }

    private SensorGroup<MethodSensor> generateSwipeableSensor() {
        MethodInfo methodInfo = new MethodInfo(SWIPE_FUNCTION_NAME, SWIPE_DESCRIPTION, 17, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> SWIPE_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeSwipeTransformation()));
    }

    private SensorGroup<MethodSensor> generateSemanticsNodeSensor() {
        MethodInfo methodInfo = new MethodInfo(NODE_FUNCTION_NAME, NODE_DESCRIPTION, 1, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> NODE_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeNodeTransformation()));
    }

    private SensorGroup<MethodSensor> generateAccessibilitySemanticsNodeSensor() {
        MethodInfo methodInfo = new MethodInfo(ACCESSIBILITY_NODE_FUNCTION_NAME, ACCESSIBILITY_NODE_DESCRIPTION, 1, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> ACCESSIBILITY_NODE_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeAccessibilityNodeTransformation()));
    }

    private SensorGroup<MethodSensor> generateDependencySensor() {
        MethodInfo methodInfo = new MethodInfo(DEPENDENCY_FUNCTION_NAME, DEPENDENCY_FUNCTION_DESCRIPTION, 9, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> DEPENDENCY_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ComposeDependencyCheckerTransformation()));
    }

    @Override
    public List<String> mandatoryClasses() {
        return List.of(DEPENDENCY_SOURCE);
    }

    public static class Sensors
    implements Serializable {
        private final boolean composeClickable;
        private final boolean composeSwipeable;
        private final boolean composeSemantics;

        private Sensors(boolean composeClickable, boolean composeSwipeable, boolean composeSemantics) {
            this.composeClickable = composeClickable;
            this.composeSwipeable = composeSwipeable;
            this.composeSemantics = composeSemantics;
        }

        public static Sensors allSensorsActivated() {
            return new Builder().withComposeClickable(true).withComposeSwipeable(true).withComposeSemantics(true).build();
        }

        public static class Builder {
            private boolean composeClickable;
            private boolean composeSwipeable;
            private boolean composeSemantics;

            public Builder withComposeClickable(boolean composeClickable) {
                this.composeClickable = composeClickable;
                return this;
            }

            public Builder withComposeSwipeable(boolean composeSwipeable) {
                this.composeSwipeable = composeSwipeable;
                return this;
            }

            public Builder withComposeSemantics(boolean composeSemantics) {
                this.composeSemantics = composeSemantics;
                return this;
            }

            public Sensors build() {
                return new Sensors(this.composeClickable, this.composeSwipeable, this.composeSemantics);
            }
        }
    }
}

