/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.instrumentation.FramesComputationMode;
import com.android.build.api.instrumentation.InstrumentationScope;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.api.variant.ApplicationVariant;
import com.android.build.api.variant.Component;
import com.android.build.api.variant.Variant;
import com.dynatrace.tools.android.AgpVersion;
import com.dynatrace.tools.android.AgpVersionConverter;
import com.dynatrace.tools.android.DependencyProducer;
import com.dynatrace.tools.android.DynatraceGradleProperties;
import com.dynatrace.tools.android.PrintVariantAffiliationTask;
import com.dynatrace.tools.android.api.VerificationUtil;
import com.dynatrace.tools.android.dependencies.DependencyVerifier;
import com.dynatrace.tools.android.dsl.DynatraceExtension;
import com.dynatrace.tools.android.dsl.VariantConfiguration;
import com.dynatrace.tools.android.dsl.VariantConfigurationUtil;
import com.dynatrace.tools.android.manifest.ManifestTransformationTask;
import com.dynatrace.tools.android.transformation.AsmVariantConfigurator;
import com.dynatrace.tools.android.transformation.AsmVariantConfiguratorFactory;
import com.dynatrace.tools.android.transformation.DynatraceClassVisitorFactory;
import com.dynatrace.tools.android.util.Utils;
import java.util.Optional;
import kotlin.Unit;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.TaskProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentationPlugin
implements Plugin<Project> {
    private static final Logger logger = LoggerFactory.getLogger((String)"InstrumentationPlugin");

    static DynatraceExtension determineExtension(Project project) {
        DynatraceExtension extension = (DynatraceExtension)project.getRootProject().getExtensions().findByType(DynatraceExtension.class);
        if (extension == null) {
            extension = (DynatraceExtension)project.getExtensions().findByType(DynatraceExtension.class);
        }
        return extension;
    }

    public void apply(Project project) {
        DynatraceGradleProperties gradleProperties = new DynatraceGradleProperties.PropertyFactory().fromProject(project).build();
        DynatraceExtension dynatraceExtension = InstrumentationPlugin.determineExtension(project);
        if (dynatraceExtension == null) {
            throw new GradleException("No Dynatrace extension found");
        }
        AgpVersion agpVersion = new AgpVersionConverter().determineAndroidPluginVersion(project);
        AndroidComponentsExtension androidExtension = (AndroidComponentsExtension)project.getExtensions().getByType(AndroidComponentsExtension.class);
        boolean isApplicationModule = project.getPlugins().hasPlugin("com.android.application");
        if (isApplicationModule) {
            this.configureMobileAgentDependencies(project);
        }
        TaskProvider<PrintVariantAffiliationTask> pvTask = this.createPrintVariantAffiliationTask(project);
        DependencyVerifier dependencyVerifier = new DependencyVerifier(project);
        androidExtension.onVariants(androidExtension.selector().all(), variant -> {
            Optional<VariantConfiguration> configuration = this.getVerifiedConfiguration((Variant)variant, dynatraceExtension);
            logger.debug("Setup transformation for variant '{}' using configuration {}", (Object)variant.getName(), configuration);
            boolean isEnabled = configuration.map(VariantConfiguration::isEnabled).orElse(false);
            pvTask.configure(task -> task.getVariantMapping().put((Object)variant.getName(), configuration.map(VariantConfiguration::getName)));
            if (isApplicationModule) {
                boolean isSessionReplayCustomer;
                if (isEnabled) {
                    this.setupManifestInstrumentation((ApplicationVariant)variant, project);
                }
                if (isSessionReplayCustomer = dynatraceExtension.getConfigurations().stream().anyMatch(it -> it.getSessionReplay().isEnabled())) {
                    this.configureSessionReplayDependencies(project, variant.getName(), isEnabled && configuration.get().getSessionReplay().isEnabled());
                }
            }
            if (isEnabled) {
                dependencyVerifier.configureAgentArtifactVerification(variant.getName() + "RuntimeClasspath");
                this.setupBytecodeInstrumentation((Variant)variant, configuration.get(), agpVersion, gradleProperties);
            }
        });
    }

    private TaskProvider<PrintVariantAffiliationTask> createPrintVariantAffiliationTask(Project project) {
        return project.getTasks().register("printVariantAffiliation", PrintVariantAffiliationTask.class, printVariantAffiliationTask -> {
            printVariantAffiliationTask.setGroup("transformation");
            printVariantAffiliationTask.setDescription("Prints which Dynatrace variant configuration is used for each variant");
        });
    }

    private Optional<VariantConfiguration> getVerifiedConfiguration(Variant variant, DynatraceExtension dynatraceExtension) {
        if (dynatraceExtension.isStrictMode() && dynatraceExtension.getConfigurations().isEmpty()) {
            throw new GradleException("No configuration for the Dynatrace Android Gradle plugin found! Please copy the configuration block from the instrumentation wizard to the proper location.");
        }
        if (!dynatraceExtension.isPluginEnabled()) {
            return Optional.empty();
        }
        Optional<VariantConfiguration> result = VariantConfigurationUtil.determineVariantConfiguration(dynatraceExtension, variant.getName());
        if (result.isPresent()) {
            VariantConfiguration config = result.get();
            VerificationUtil.verifyVariantConfiguration("Invalid configuration '" + config.getName() + "': ", config);
            return result;
        }
        if (dynatraceExtension.isStrictMode()) {
            throw new GradleException("No configuration for the Dynatrace Android Gradle plugin found that matches variant: '" + variant.getName() + "'");
        }
        return Optional.empty();
    }

    private void setupBytecodeInstrumentation(Variant variant, VariantConfiguration configuration, AgpVersion agpVersion, DynatraceGradleProperties gradleProperties) {
        AsmVariantConfigurator variantConfigurator = new AsmVariantConfiguratorFactory().createAsmVariantConfigurator(agpVersion);
        variantConfigurator.transformClassesWith((Component)variant, DynatraceClassVisitorFactory.class, InstrumentationScope.ALL, params -> {
            params.getVariantConfiguration().set((Object)configuration);
            params.getVariantConfiguration().disallowChanges();
            params.getInstrumentationFlavor().set((Object)gradleProperties.getInstrumentationFlavor());
            params.getInstrumentationFlavor().disallowChanges();
            params.getSessionReplayComposeIsInstrumentable().set((Object)gradleProperties.isSessionReplayComposeEnabled());
            params.getSessionReplayComposeIsInstrumentable().disallowChanges();
            return Unit.INSTANCE;
        });
        variantConfigurator.setAsmFramesComputationMode((Component)variant, FramesComputationMode.COMPUTE_FRAMES_FOR_INSTRUMENTED_CLASSES);
    }

    private void setupManifestInstrumentation(ApplicationVariant variant, Project project) {
        TaskProvider manifestTransformTask = project.getTasks().register("instrument" + Utils.capitalize(variant.getName()) + "ManifestWithDynatrace", ManifestTransformationTask.class);
        variant.getArtifacts().use(manifestTransformTask).wiredWithFiles(ManifestTransformationTask::getInputManifest, ManifestTransformationTask::getInstrumentedManifest).toTransform((Artifact.Single)SingleArtifact.MERGED_MANIFEST.INSTANCE);
    }

    private void configureMobileAgentDependencies(Project project) {
        Configuration config = project.getConfigurations().getByName("api");
        config.withDependencies(dependencies -> dependencies.add((Object)project.getDependencies().create((Object)DependencyProducer.mobileAgent())));
    }

    private void configureSessionReplayDependencies(Project project, String variantName, boolean addAgentDependency) {
        Configuration config = project.getConfigurations().getByName(variantName + "Api");
        if (addAgentDependency) {
            config.withDependencies(dependencies -> dependencies.add((Object)project.getDependencies().create((Object)DependencyProducer.sessionReplay())));
        } else {
            config.withDependencies(dependencies -> dependencies.add((Object)project.getDependencies().create((Object)DependencyProducer.sessionReplayNoop())));
        }
    }
}

