/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.ClassLoaderClassInfo;
import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.IncompleteClassInfo;

public class ClassLoaderClassResolver
implements ClassResolver {
    private final ClassLoader classLoader;

    public ClassLoaderClassResolver(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public ClassInfo resolveClass(String className) {
        try {
            Class<?> clazz = Class.forName(className, false, this.classLoader);
            return new ClassLoaderClassInfo(clazz, this.classLoader);
        }
        catch (UnsupportedClassVersionError e) {
            throw e;
        }
        catch (Throwable e) {
            return new IncompleteClassInfo(className);
        }
    }

    @Deprecated
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

