/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose;

import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import com.dynatrace.android.instrumentation.shared.TransformerUtils;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ComposeNodeTransformation
implements MethodTransformation {
    private static final int NUM_OF_INIT_LOCALS = 4;
    public static final int LOCAL_SEM_MOD_NODE = 5;

    @Override
    public void transformMethod(MethodNode methodNode, int startParameterIndex) {
        TransformerUtils.insertAtMethodStart(methodNode, instructions -> {
            this.resetSemanticsConfiguration(instructions);
            this.loadReleaseActionStateOntoStack(instructions);
            LabelNode labelNode = new LabelNode();
            instructions.add((AbstractInsnNode)new JumpInsnNode(153, labelNode));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            this.loadNodeCoordinatorOntoStack(instructions);
            instructions.add((AbstractInsnNode)new JumpInsnNode(198, labelNode));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new MethodInsnNode(184, "androidx/compose/ui/node/DelegatableNodeKt", "requireLayoutNode", "(Landroidx/compose/ui/node/DelegatableNode;)Landroidx/compose/ui/node/LayoutNode;", false));
            instructions.add((AbstractInsnNode)new MethodInsnNode(184, "androidx/compose/ui/semantics/SemanticsNodeKt", "getOuterSemantics", "(Landroidx/compose/ui/node/LayoutNode;)Landroidx/compose/ui/node/SemanticsModifierNode;", false));
            instructions.add((AbstractInsnNode)new VarInsnNode(58, 5));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 5));
            instructions.add((AbstractInsnNode)new JumpInsnNode(198, labelNode));
            this.obtainAndStoreConfigurationInSemanticsManager(instructions, 5);
            instructions.add((AbstractInsnNode)labelNode);
        });
    }

    public void loadReleaseActionStateOntoStack(InsnList instructions) {
        instructions.add((AbstractInsnNode)new FieldInsnNode(178, "com/dynatrace/android/compose/SemanticsManager", "INSTANCE", "Lcom/dynatrace/android/compose/SemanticsManager;"));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, "com/dynatrace/android/compose/SemanticsManager", "isReleaseActionState", "(Landroidx/compose/ui/input/pointer/PointerEvent;)Z", false));
    }

    public void loadNodeCoordinatorOntoStack(InsnList instructions) {
        instructions.add((AbstractInsnNode)new MethodInsnNode(185, "androidx/compose/ui/node/SemanticsModifierNode", "getNode", "()Landroidx/compose/ui/Modifier$Node;", true));
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, "androidx/compose/ui/Modifier$Node", "getCoordinator$ui_release", "()Landroidx/compose/ui/node/NodeCoordinator;", false));
    }

    public void obtainAndStoreConfigurationInSemanticsManager(InsnList instructions, int nodeSemanticsIndex) {
        instructions.add((AbstractInsnNode)new FieldInsnNode(178, "com/dynatrace/android/compose/SemanticsManager", "INSTANCE", "Lcom/dynatrace/android/compose/SemanticsManager;"));
        instructions.add((AbstractInsnNode)new TypeInsnNode(187, "androidx/compose/ui/semantics/SemanticsNode"));
        instructions.add((AbstractInsnNode)new InsnNode(89));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, nodeSemanticsIndex));
        instructions.add((AbstractInsnNode)new InsnNode(4));
        instructions.add((AbstractInsnNode)new InsnNode(1));
        instructions.add((AbstractInsnNode)new InsnNode(7));
        instructions.add((AbstractInsnNode)new InsnNode(1));
        instructions.add((AbstractInsnNode)new MethodInsnNode(183, "androidx/compose/ui/semantics/SemanticsNode", "<init>", "(Landroidx/compose/ui/node/SemanticsModifierNode;ZLandroidx/compose/ui/node/LayoutNode;ILkotlin/jvm/internal/DefaultConstructorMarker;)V", false));
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, "androidx/compose/ui/semantics/SemanticsNode", "getConfig", "()Landroidx/compose/ui/semantics/SemanticsConfiguration;", false));
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, "com/dynatrace/android/compose/SemanticsManager", "setConfiguration", "(Landroidx/compose/ui/semantics/SemanticsConfiguration;)V", false));
    }

    public void resetSemanticsConfiguration(InsnList instructions) {
        instructions.add((AbstractInsnNode)new FieldInsnNode(178, "com/dynatrace/android/compose/SemanticsManager", "INSTANCE", "Lcom/dynatrace/android/compose/SemanticsManager;"));
        instructions.add((AbstractInsnNode)new InsnNode(1));
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, "com/dynatrace/android/compose/SemanticsManager", "setConfiguration", "(Landroidx/compose/ui/semantics/SemanticsConfiguration;)V", false));
    }
}

