/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import com.android.build.api.transform.Transform;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.dynatrace.tools.android.AgpVersion;
import com.dynatrace.tools.android.AgpVersionParser;
import com.dynatrace.tools.android.DependencyProducer;
import com.dynatrace.tools.android.DynatraceGradleProperties;
import com.dynatrace.tools.android.DynatraceTransformer;
import com.dynatrace.tools.android.LegacyPrintVariantAffiliationTask;
import com.dynatrace.tools.android.api.VerificationUtil;
import com.dynatrace.tools.android.dsl.DynatraceExtension;
import com.dynatrace.tools.android.dsl.VariantConfiguration;
import com.dynatrace.tools.android.dsl.VariantConfigurationUtil;
import com.dynatrace.tools.android.manifest.ManifestInstrumentorAppBundle;
import com.dynatrace.tools.android.manifest.ManifestInstrumentorMultiApk;
import com.dynatrace.tools.android.manifest.StrictErrorAction;
import com.dynatrace.tools.android.util.Utils;
import com.google.common.base.CaseFormat;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.TaskProvider;

@Deprecated
public class LegacyInstrumentationPlugin
implements Plugin<Project> {
    private static String generateTransformTaskNamePrefix(Transform transformer) {
        return "transform" + transformer.getInputTypes().stream().map(inputType -> CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, inputType.name())).sorted().collect(Collectors.joining("And")) + "With" + Utils.capitalize(transformer.getName()) + "For";
    }

    static DynatraceExtension determineExtension(Project project) {
        DynatraceExtension extension = (DynatraceExtension)project.getRootProject().getExtensions().findByType(DynatraceExtension.class);
        if (extension == null) {
            extension = (DynatraceExtension)project.getExtensions().findByType(DynatraceExtension.class);
        }
        return extension;
    }

    public void apply(Project project) {
        DynatraceGradleProperties gradleProperties = new DynatraceGradleProperties.PropertyFactory().fromProject(project).build();
        AgpVersion agpVersion = new AgpVersionParser().determineAgpVersionLegacy();
        AppExtension androidExt = (AppExtension)project.getExtensions().getByType(AppExtension.class);
        DynatraceExtension extension = LegacyInstrumentationPlugin.determineExtension(project);
        if (extension == null) {
            throw new GradleException("No Dynatrace extension found");
        }
        DynatraceTransformer transformer = new DynatraceTransformer(extension, androidExt, gradleProperties.getInstrumentationFlavor());
        androidExt.registerTransform((Transform)transformer, new Object[0]);
        project.getTasks().register("printVariantAffiliation", LegacyPrintVariantAffiliationTask.class, printVariantAffiliationTask -> {
            printVariantAffiliationTask.setGroup("transformation");
            printVariantAffiliationTask.setDescription("Prints which Dynatrace variant configuration is used for each variant");
        });
        boolean isApplicationModule = project.getPlugins().hasPlugin("com.android.application");
        if (isApplicationModule) {
            Configuration config = project.getConfigurations().getByName("api");
            config.withDependencies(dependencies -> dependencies.add((Object)project.getDependencies().create((Object)DependencyProducer.mobileAgent())));
            androidExt.getApplicationVariants().configureEach(applicationVariant -> {
                boolean isSessionReplayCustomer = extension.getConfigurations().stream().anyMatch(it -> it.getSessionReplay().isEnabled());
                if (isSessionReplayCustomer) {
                    Optional<VariantConfiguration> result = !extension.isPluginEnabled() ? Optional.empty() : VariantConfigurationUtil.determineVariantConfiguration(extension, applicationVariant.getName());
                    boolean isEnabled = result.map(VariantConfiguration::isEnabled).orElse(false);
                    Configuration configVariantSpecific = project.getConfigurations().getByName(applicationVariant.getName() + "Api");
                    if (isEnabled && ((VariantConfiguration)result.get()).getSessionReplay().isEnabled()) {
                        configVariantSpecific.withDependencies(dependencies -> dependencies.add((Object)project.getDependencies().create((Object)DependencyProducer.sessionReplay())));
                    } else {
                        configVariantSpecific.withDependencies(dependencies -> dependencies.add((Object)project.getDependencies().create((Object)DependencyProducer.sessionReplayNoop())));
                    }
                }
            });
        }
        project.afterEvaluate(projectParam -> {
            if (extension.isStrictMode() && extension.getConfigurations().isEmpty()) {
                throw new GradleException("No configuration for the Dynatrace Android Gradle plugin found! Please copy the configuration block from the instrumentation wizard to the proper location.");
            }
            if (extension.isPluginEnabled()) {
                extension.getConfigurations().configureEach(config -> VerificationUtil.verifyVariantConfiguration("Invalid configuration '" + config.getName() + "': ", config));
            }
            String genericTaskName = LegacyInstrumentationPlugin.generateTransformTaskNamePrefix(transformer);
            androidExt.getApplicationVariants().configureEach(applicationVariant -> {
                Optional<VariantConfiguration> result = !extension.isPluginEnabled() ? Optional.empty() : VariantConfigurationUtil.determineVariantConfiguration(extension, applicationVariant.getName());
                TaskProvider transformTaskProvider = project.getTasks().named(genericTaskName + Utils.capitalize(applicationVariant.getName()));
                transformTaskProvider.configure(this.configureTransformTask(androidExt, (ApplicationVariant)applicationVariant, transformer, result));
                if (isApplicationModule) {
                    if (result.isPresent()) {
                        VariantConfiguration conf = result.get();
                        if (conf.isEnabled()) {
                            TaskProvider manifestTaskProvider = project.getTasks().named("process" + Utils.capitalize(applicationVariant.getName()) + "Manifest");
                            manifestTaskProvider.configure(this.configureManifestTask((ApplicationVariant)applicationVariant, agpVersion, conf.getDebug().isFailOnWarnings()));
                        }
                    } else if (extension.isStrictMode() && extension.isPluginEnabled()) {
                        TaskProvider manifestTaskProvider = project.getTasks().named("process" + Utils.capitalize(applicationVariant.getName()) + "Manifest");
                        manifestTaskProvider.configure(this.configureManifestTaskError(applicationVariant.getName()));
                    }
                }
            });
        });
    }

    private Action<? super Task> configureTransformTask(AppExtension androidExt, ApplicationVariant applicationVariant, DynatraceTransformer transformer, Optional<VariantConfiguration> result) {
        return task -> {
            TaskInputs input = task.getInputs();
            TaskOutputs output = task.getOutputs();
            boolean caching = false;
            if (result.isPresent()) {
                VariantConfiguration origConf = (VariantConfiguration)result.get();
                transformer.addVariantSpecificConfiguration(applicationVariant.getName(), origConf);
                input.property("variantConfiguration", (Object)VariantConfigurationUtil.copy(origConf));
                caching = origConf.isEnabled();
            }
            input.files(new Object[]{androidExt.getBootClasspath()}).withPropertyName("bootClasspath").withPathSensitivity(PathSensitivity.NAME_ONLY);
            if (!caching) {
                output.cacheIf(task1 -> false);
            }
        };
    }

    private Action<? super Task> configureManifestTask(ApplicationVariant applicationVariant, AgpVersion agpVersion, boolean failsOnWarning) {
        return manifestProcessorTask -> {
            TaskInputs input = manifestProcessorTask.getInputs();
            input.property("failsOnWarning", (Object)failsOnWarning);
            applicationVariant.getOutputs().configureEach(apkVariant -> {
                String subVariantName = apkVariant.getDirName().replaceAll("[/$\\\\]", "");
                if (agpVersion.equals(new AgpVersion(4, 0))) {
                    manifestProcessorTask.doLast((Action)new ManifestInstrumentorAppBundle(subVariantName, agpVersion, failsOnWarning));
                } else {
                    manifestProcessorTask.doLast((Action)new ManifestInstrumentorMultiApk(subVariantName, failsOnWarning));
                }
            });
        };
    }

    private Action<? super Task> configureManifestTaskError(String variantName) {
        return manifestProcessorTask -> {
            TaskInputs input = manifestProcessorTask.getInputs();
            input.property("strictModeError", (Object)variantName);
            manifestProcessorTask.doLast((Action)new StrictErrorAction(variantName));
        };
    }
}

