/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory.replay.compose;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.sensor.method.StartMethodTransformation;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SessionReplayComposeTransformerFactory
implements TransformerFactory {
    private static final String ANDROID_COMPOSE_VIEW_SOURCE = "androidx.compose.ui.platform.AndroidComposeView";
    private static final String ON_LAYOUT_CHANGE_FUNCTION_NAME = "onLayoutChange";
    private static final String ON_LAYOUT_CHANGE_DESCRIPTION = "(Landroidx/compose/ui/node/LayoutNode;)V";
    private static final String CORE_TEXT_FIELD_SOURCE = "androidx.compose.foundation.text.CoreTextFieldKt";
    private static final String CORE_TEXT_FIELD_FUNCTION_NAME = "CoreTextField";
    private static final String CORE_TEXT_FIELD_DESCRIPTION_1_3 = "(Landroidx/compose/ui/text/input/TextFieldValue;Lkotlin/jvm/functions/Function1;Landroidx/compose/ui/Modifier;Landroidx/compose/ui/text/TextStyle;Landroidx/compose/ui/text/input/VisualTransformation;Lkotlin/jvm/functions/Function1;Landroidx/compose/foundation/interaction/MutableInteractionSource;Landroidx/compose/ui/graphics/Brush;ZILandroidx/compose/ui/text/input/ImeOptions;Landroidx/compose/foundation/text/KeyboardActions;ZZLkotlin/jvm/functions/Function3;Landroidx/compose/runtime/Composer;III)V";
    private static final String CORE_TEXT_FIELD_DESCRIPTION_1_4 = "(Landroidx/compose/ui/text/input/TextFieldValue;Lkotlin/jvm/functions/Function1;Landroidx/compose/ui/Modifier;Landroidx/compose/ui/text/TextStyle;Landroidx/compose/ui/text/input/VisualTransformation;Lkotlin/jvm/functions/Function1;Landroidx/compose/foundation/interaction/MutableInteractionSource;Landroidx/compose/ui/graphics/Brush;ZIILandroidx/compose/ui/text/input/ImeOptions;Landroidx/compose/foundation/text/KeyboardActions;ZZLkotlin/jvm/functions/Function3;Landroidx/compose/runtime/Composer;III)V";
    private static final String TEXT_FIELD_STATE_SOURCE = "androidx.compose.foundation.text.TextFieldState";
    private static final String TEXT_FIELD_STATE_FUNCTION_NAME = "setHasFocus";
    private static final String TEXT_FIELD_STATE_DESCRIPTION = "(Z)V";

    @Override
    public SubTransformer generateTransformer(ClassResolver classResolver) throws Exception {
        ArrayList<SensorGroup<MethodSensor>> sensors = new ArrayList<SensorGroup<MethodSensor>>();
        sensors.add(this.generateOnLayoutChangeSensor());
        sensors.add(this.generateCoreTextFieldSensor());
        sensors.add(this.generateTextFieldStateSensor());
        return new DefaultSubTransformer("SessionReplayComposeTransformerFactory", new ArrayList<SensorGroup<InstructionSensor>>(), sensors, classResolver);
    }

    private SensorGroup<MethodSensor> generateOnLayoutChangeSensor() {
        MethodInfo methodInfo = new MethodInfo(ON_LAYOUT_CHANGE_FUNCTION_NAME, ON_LAYOUT_CHANGE_DESCRIPTION, 1, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> ANDROID_COMPOSE_VIEW_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new StartMethodTransformation(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.internal.api.compose.InstrumentorComposeApi"), ON_LAYOUT_CHANGE_FUNCTION_NAME, "(Landroidx/compose/ui/layout/LayoutInfo;)V"), ParameterInstructionProvider.withAllParameters(ON_LAYOUT_CHANGE_DESCRIPTION))));
    }

    private SensorGroup<MethodSensor> generateCoreTextFieldSensor() {
        MethodInfo methodInfo13 = new MethodInfo(CORE_TEXT_FIELD_FUNCTION_NAME, CORE_TEXT_FIELD_DESCRIPTION_1_3, 25, null, new ArrayList<String>());
        MethodInfo methodInfo14 = new MethodInfo(CORE_TEXT_FIELD_FUNCTION_NAME, CORE_TEXT_FIELD_DESCRIPTION_1_4, 25, null, new ArrayList<String>());
        ParameterInstructionProvider provider = (instructions, startParameterIndex) -> {
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
        };
        StartMethodTransformation transformation = new StartMethodTransformation(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.internal.api.compose.InstrumentorComposeApi"), "coreTextField", "(Landroidx/compose/ui/text/input/TextFieldValue;Landroidx/compose/ui/Modifier;)V"), provider);
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> CORE_TEXT_FIELD_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo13, transformation), new MethodSensorImpl(methodInfo14, transformation));
    }

    private SensorGroup<MethodSensor> generateTextFieldStateSensor() {
        MethodInfo methodInfo = new MethodInfo(TEXT_FIELD_STATE_FUNCTION_NAME, TEXT_FIELD_STATE_DESCRIPTION, 17, null, new ArrayList<String>());
        ParameterInstructionProvider provider = (instructions, startParameterIndex) -> {
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new MethodInsnNode(182, "androidx/compose/foundation/text/TextFieldState", "getLayoutCoordinates", "()Landroidx/compose/ui/layout/LayoutCoordinates;", false));
            instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
        };
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> TEXT_FIELD_STATE_SOURCE.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new StartMethodTransformation(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.internal.api.compose.InstrumentorComposeApi"), "textFieldStateFocus", "(Landroidx/compose/ui/layout/LayoutCoordinates;Z)V"), provider)));
    }
}

