/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.Instrumentor;
import com.dynatrace.android.instrumentation.filter.ExclusionManager;
import com.dynatrace.android.instrumentation.sensor.agent.AutoStartTransformation;
import com.dynatrace.android.instrumentation.sensor.agent.InstrumentationFlavor;
import com.dynatrace.android.instrumentation.sensor.agent.PresetConfiguration;
import com.dynatrace.android.instrumentation.transform.factory.AgentConfigurationTransformerFactory;
import com.dynatrace.android.instrumentation.transform.factory.ComposePagerTransformFactory;
import com.dynatrace.android.instrumentation.transform.factory.ComposeTransformFactory;
import com.dynatrace.android.instrumentation.transform.factory.HttpClientTransformerFactory;
import com.dynatrace.android.instrumentation.transform.factory.HttpUrlConnectionTransformerFactory;
import com.dynatrace.android.instrumentation.transform.factory.HybridAppTransformerFactory;
import com.dynatrace.android.instrumentation.transform.factory.LifecycleTransformerFactory;
import com.dynatrace.android.instrumentation.transform.factory.LocationTransformerFactory;
import com.dynatrace.android.instrumentation.transform.factory.OkHttpTransformerFactory;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.transform.factory.UserActionTransformerFactory;
import com.dynatrace.android.instrumentation.transform.factory.replay.FullSessionReplayTransformerFactory;
import com.dynatrace.android.instrumentation.transform.factory.replay.ServiceInitializationTransformerFactory;
import com.dynatrace.android.instrumentation.transform.factory.replay.SessionReplayCompoundButtonTransformerFactory;
import com.dynatrace.android.instrumentation.transform.factory.replay.SessionReplayFragmentTransformerFactory;
import com.dynatrace.android.instrumentation.transform.factory.replay.SessionReplayNavDrawerTransformerFactory;
import com.dynatrace.android.instrumentation.transform.factory.replay.SessionReplayScrollTransformerFactory;
import com.dynatrace.android.instrumentation.transform.factory.replay.SessionReplayTableReloadTransformerFactory;
import com.dynatrace.android.instrumentation.transform.factory.replay.SessionReplayWebViewTransformerFactory;
import com.dynatrace.android.instrumentation.transform.factory.replay.compose.SessionReplayComposeTransformerFactory;
import com.dynatrace.tools.android.api.AgentBehaviorOptions;
import com.dynatrace.tools.android.api.BehavioralEventsOptions;
import com.dynatrace.tools.android.api.Configuration;
import com.dynatrace.tools.android.api.DebugOptions;
import com.dynatrace.tools.android.api.HybridOptions;
import com.dynatrace.tools.android.api.LifecycleOptions;
import com.dynatrace.tools.android.api.StartOptions;
import com.dynatrace.tools.android.api.UserActionOptions;
import com.dynatrace.tools.android.api.WebRequestOptions;
import java.util.ArrayList;
import java.util.List;

public class InstrumentorConfigurator {
    private final Configuration configuration;
    private final InstrumentationFlavor instrumentationFlavor;
    private final boolean instrumentComposeReplay;
    private final boolean isFullSessionReplayEnabled;

    public InstrumentorConfigurator(Configuration configuration, InstrumentationFlavor instrumentationFlavor, boolean instrumentComposeReplay, boolean isFullSessionReplayEnabled) {
        this.configuration = configuration;
        this.instrumentationFlavor = instrumentationFlavor;
        this.instrumentComposeReplay = instrumentComposeReplay;
        this.isFullSessionReplayEnabled = isFullSessionReplayEnabled;
    }

    public List<TransformerFactory> selectTransformerFactories() {
        Object sensors;
        UserActionOptions userActionOptions = this.configuration.getUserActions();
        HybridOptions hybridOptions = this.configuration.getHybridWebView();
        WebRequestOptions webRequestOptions = this.configuration.getWebRequests();
        ArrayList<TransformerFactory> factories = new ArrayList<TransformerFactory>();
        if (userActionOptions.isEnabled()) {
            sensors = userActionOptions.getSensors();
            factories.add(new UserActionTransformerFactory(new UserActionTransformerFactory.Sensors.Builder().withOnClickListener(sensors.isClick()).withOnItemClickListener(sensors.isItemClick()).withOnItemSelectedListener(sensors.isItemSelect()).withOnMenuItemClickListener(sensors.isMenuClick()).withOnPageChangeListener(sensors.isPageChange()).withOnRefreshListener(sensors.isRefresh()).withOnOptionsItemSelected(sensors.isOptionSelect()).build()));
            if (userActionOptions.isComposeEnabled()) {
                boolean isComposeSemantics = !this.configuration.getUserActions().isNamePrivacy() && sensors.isComposeSemantics();
                factories.add(new ComposeTransformFactory(new ComposeTransformFactory.Sensors.Builder().withComposeClickable(sensors.isComposeClickable()).withComposeSwipeable(sensors.isComposeSwipeable()).withComposeSemantics(isComposeSemantics).withComposeSlider(sensors.isComposeSlider()).withComposePullRefresh(sensors.isComposePullRefresh()).build()));
                if (sensors.isComposePager()) {
                    factories.add(new ComposePagerTransformFactory(isComposeSemantics));
                }
            }
            if (this.instrumentComposeReplay) {
                factories.add(new SessionReplayComposeTransformerFactory());
            }
            if (this.isFullSessionReplayEnabled) {
                factories.add(new FullSessionReplayTransformerFactory());
            }
        }
        if (webRequestOptions.isEnabled()) {
            sensors = webRequestOptions.getSensors();
            if (sensors.isHttpUrlConnection()) {
                factories.add(new HttpUrlConnectionTransformerFactory());
            }
            if (sensors.isOkHttp()) {
                factories.add(new OkHttpTransformerFactory());
            }
            if (sensors.isHttpClient()) {
                factories.add(new HttpClientTransformerFactory());
            }
        }
        factories.add(new LifecycleTransformerFactory());
        if (hybridOptions.isEnabled()) {
            factories.add(new HybridAppTransformerFactory());
        }
        if (this.configuration.isLocationMonitoring()) {
            factories.add(new LocationTransformerFactory());
        }
        factories.add(new AgentConfigurationTransformerFactory(this.generateBuilderConfiguration(), this.generatePresetConfiguration()));
        if (this.configuration.getSessionReplay().isEnabled()) {
            factories.add(new ServiceInitializationTransformerFactory());
            factories.add(new SessionReplayWebViewTransformerFactory());
            factories.add(new SessionReplayScrollTransformerFactory());
            factories.add(new SessionReplayTableReloadTransformerFactory());
            factories.add(new SessionReplayFragmentTransformerFactory());
            factories.add(new SessionReplayCompoundButtonTransformerFactory());
            factories.add(new SessionReplayNavDrawerTransformerFactory());
        }
        return factories;
    }

    AutoStartTransformation.BuilderConfiguration generateBuilderConfiguration() {
        StartOptions startOptions = this.configuration.getAutoStart();
        if (!startOptions.isEnabled()) {
            return null;
        }
        boolean isSaas = startOptions.getBeaconUrl() != null;
        return new AutoStartTransformation.BuilderConfiguration(startOptions.getApplicationId(), isSaas ? startOptions.getBeaconUrl() : startOptions.getAgentPath(), isSaas);
    }

    PresetConfiguration generatePresetConfiguration() {
        PresetConfiguration.Builder builder = new PresetConfiguration.Builder().withWebRequestTiming(this.configuration.getWebRequests().isEnabled()).withCrashReporting(this.configuration.isCrashReporting()).withUserOptIn(this.configuration.isUserOptIn()).withAutoStart(this.configuration.getAutoStart().isEnabled()).withInstrumentationFlavor(this.instrumentationFlavor).withSessionReplayEnabled(this.configuration.getSessionReplay().isEnabled());
        UserActionOptions userActionOptions = this.configuration.getUserActions();
        builder.withGraceTime(userActionOptions.getTimeout()).withWaitTime(userActionOptions.getMaxDuration()).withSendEmptyActions(userActionOptions.isEmptyActions()).withNamePrivacy(userActionOptions.isNamePrivacy());
        LifecycleOptions lifecycleOptions = this.configuration.getLifecycle();
        builder.withApplicationMonitoring(lifecycleOptions.isEnabled() && lifecycleOptions.getSensors().isApplication()).withActivityMonitoring(lifecycleOptions.isEnabled() && lifecycleOptions.getSensors().isActivity());
        HybridOptions hybridOptions = this.configuration.getHybridWebView();
        builder.withMonitoredDomains(hybridOptions.getDomains().toArray(new String[0])).withMonitoredHttpsDomains(hybridOptions.getHttpsDomains().toArray(new String[0])).withHybridApp(hybridOptions.isEnabled()).withFileDomainCookies(hybridOptions.isFileDomainCookies());
        AgentBehaviorOptions agentBehaviorOptions = this.configuration.getAgentBehavior();
        builder.withStartupLoadBalancing(agentBehaviorOptions.isStartupLoadBalancing());
        BehavioralEventsOptions behavioralEventsOptions = this.configuration.getBehavioralEvents();
        builder.withRageTapDetection(behavioralEventsOptions.isDetectRageTaps());
        DebugOptions debugOptions = this.configuration.getDebug();
        builder.withCertificateValidation(debugOptions.isCertificateValidation()).withDebugLogLevel(debugOptions.isAgentLogging());
        return builder.build();
    }

    public Instrumentor generateVariantSpecificInstrumentor(ClassResolver classResolver, ExclusionManager exclusionManager) throws Exception {
        return new Instrumentor.Builder().setClassResolver(classResolver).setTransformerFactories(this.selectTransformerFactories()).setExclusionManager(exclusionManager).build();
    }
}

