/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.sensor.compose.ComposePagerStateTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.ComposePagerTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.ComposePagerTransformation_1_5;
import com.dynatrace.android.instrumentation.sensor.compose.ComposeVersion;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.compose.ComposeSubTransformer;
import com.dynatrace.android.instrumentation.transform.compose.ComposeTransformation;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import java.util.ArrayList;

public class ComposePagerTransformFactory
implements TransformerFactory {
    private final boolean useSemantics;

    public ComposePagerTransformFactory(boolean useSemantics) {
        this.useSemantics = useSemantics;
    }

    @Override
    public SubTransformer generateTransformer(ClassResolver classResolver) throws Exception {
        ComposeVersion composeVersion = ComposeVersion.getVersion(classResolver);
        ArrayList<ComposeTransformation> factories = new ArrayList<ComposeTransformation>();
        if (composeVersion == ComposeVersion.V1_4) {
            factories.add(new ComposePagerTransformation(this.useSemantics));
        } else if (composeVersion == ComposeVersion.V1_5 || composeVersion == ComposeVersion.V1_6) {
            factories.add(new ComposePagerTransformation_1_5(this.useSemantics));
        } else {
            throw new UnsupportedOperationException("Instrumentation for Compose version " + composeVersion + " and higher is missing.");
        }
        factories.add(new ComposePagerStateTransformation());
        return new ComposeSubTransformer("ComposePagerTransformFactory", factories);
    }
}

