/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.dsl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class HybridOptions
implements Serializable,
com.dynatrace.tools.android.api.HybridOptions {
    private boolean enabled;
    private final List<String> domains;
    private final List<String> httpsDomains;
    private boolean fileDomainCookies;

    public HybridOptions() {
        this(false, new ArrayList<String>(), new ArrayList<String>(), true);
    }

    HybridOptions(HybridOptions source) {
        this(source.enabled, new ArrayList<String>(source.domains), new ArrayList<String>(source.httpsDomains), source.fileDomainCookies);
    }

    HybridOptions(boolean enabled, List<String> domains, List<String> httpsDomains, boolean fileDomainCookies) {
        this.enabled = enabled;
        this.domains = domains;
        this.httpsDomains = httpsDomains;
        this.fileDomainCookies = fileDomainCookies;
    }

    public void enabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void fileDomainCookies(boolean fileDomainCookies) {
        this.fileDomainCookies = fileDomainCookies;
    }

    public void domains(String domain) {
        this.domains.add(domain);
    }

    public void domains(String ... domains) {
        this.domains.addAll(Arrays.asList(domains));
    }

    public void httpsDomains(String httpsDomain) {
        this.httpsDomains.add(httpsDomain);
    }

    public void httpsDomains(String ... httpsDomains) {
        this.httpsDomains.addAll(Arrays.asList(httpsDomains));
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public List<String> getDomains() {
        return this.domains;
    }

    @Override
    public List<String> getHttpsDomains() {
        return this.httpsDomains;
    }

    @Override
    public boolean isFileDomainCookies() {
        return this.fileDomainCookies;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.domains, this.httpsDomains, this.fileDomainCookies);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HybridOptions)) {
            return false;
        }
        HybridOptions that = (HybridOptions)other;
        return this.enabled == that.enabled && Objects.equals(this.domains, that.domains) && Objects.equals(this.httpsDomains, that.httpsDomains) && this.fileDomainCookies == that.fileDomainCookies;
    }

    public String toString() {
        return "HybridOptions{enabled=" + this.enabled + ", domains=" + this.domains + ", httpsDomains=" + this.httpsDomains + ", fileDomainCookies=" + this.fileDomainCookies + "}";
    }
}

