/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose;

import com.dynatrace.android.instrumentation.ClassResolver;

public enum ComposeVersion {
    V1_7,
    V1_6,
    V1_5,
    V1_4;

    private static final String EMPTY_SEMANTICS_MODIFIER_1_5 = "androidx.compose.ui.semantics.EmptySemanticsModifier";
    private static final String RESOURCE_RESOLUTION_EXCEPTION_1_6 = "androidx.compose.ui.res.ResourceResolutionException";
    private static final String APPROACH_LAYOUT_MODIFIER_1_7 = "androidx.compose.ui.layout.ApproachLayoutModifierNode";

    public static ComposeVersion getVersion(ClassResolver classResolver) {
        if (classResolver.resolveClass(APPROACH_LAYOUT_MODIFIER_1_7).isComplete()) {
            return V1_7;
        }
        if (classResolver.resolveClass(RESOURCE_RESOLUTION_EXCEPTION_1_6).isComplete()) {
            return V1_6;
        }
        if (classResolver.resolveClass(EMPTY_SEMANTICS_MODIFIER_1_5).isComplete()) {
            return V1_5;
        }
        return V1_4;
    }

    public static String getVersionPackage(ClassResolver classResolver) {
        ComposeVersion composeVersion = ComposeVersion.getVersion(classResolver);
        String composePackage = "com/dynatrace/android/internal/api/compose14";
        if (composeVersion != V1_4) {
            composePackage = "com/dynatrace/android/internal/api/compose15";
        }
        return composePackage;
    }

    public static String getInstrumentorApi(ClassResolver classResolver) {
        ComposeVersion composeVersion = ComposeVersion.getVersion(classResolver);
        String instrumentorApi = "com.dynatrace.android.internal.api.compose14.InstrumentorComposeApi";
        if (composeVersion != V1_4) {
            instrumentorApi = "com.dynatrace.android.internal.api.compose15.InstrumentorComposeApi";
        }
        return instrumentorApi;
    }
}

