/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory.replay;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.sensor.method.StartMethodTransformation;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;

public class SessionReplayNavDrawerTransformerFactory
implements TransformerFactory {
    private static final String NAV_DRAWER_CLASS = "androidx.drawerlayout.widget.DrawerLayout";

    @Override
    public SubTransformer generateTransformer(ClassResolver classResolver) throws Exception {
        ArrayList<SensorGroup<MethodSensor>> sensors = new ArrayList<SensorGroup<MethodSensor>>();
        sensors.add(this.generateOnDrawerOpenedSensor());
        sensors.add(this.generateOnDrawerClosedSensor());
        return new DefaultSubTransformer("NavDrawerTransformer", new ArrayList<SensorGroup<InstructionSensor>>(), sensors, classResolver);
    }

    private SensorGroup<MethodSensor> generateOnDrawerOpenedSensor() {
        MethodInfo dispatchOnDrawerOpened = new MethodInfo("dispatchOnDrawerOpened", "(Landroid/view/View;)V", 0, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> NAV_DRAWER_CLASS.equals(otherClassInfo.getName()), new MethodSensorImpl(dispatchOnDrawerOpened, new StartMethodTransformation(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.internal.api.InstrumentorApi"), "onNavigationDrawerOpened", "(Landroid/view/View;)V"), ParameterInstructionProvider.withAllParameters("(Landroid/view/View;)V"))));
    }

    private SensorGroup<MethodSensor> generateOnDrawerClosedSensor() {
        MethodInfo dispatchOnDrawerOpened = new MethodInfo("dispatchOnDrawerClosed", "(Landroid/view/View;)V", 0, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> NAV_DRAWER_CLASS.equals(otherClassInfo.getName()), new MethodSensorImpl(dispatchOnDrawerOpened, new StartMethodTransformation(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.internal.api.InstrumentorApi"), "onNavigationDrawerClosed", "(Landroid/view/View;)V"), ParameterInstructionProvider.withAllParameters("(Landroid/view/View;)V"))));
    }
}

