/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose.replay;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.compose.ComposeVersion;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.sensor.method.StartMethodTransformation;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;
import java.util.List;

public class SessionReplayComposeViewSensor
implements SensorGroup<MethodSensor> {
    private static final String ANDROID_COMPOSE_VIEW_SOURCE = "androidx.compose.ui.platform.AndroidComposeView";
    private static final String ON_LAYOUT_CHANGE_FUNCTION_NAME = "onLayoutChange";
    private static final String ON_LAYOUT_CHANGE_DESCRIPTION = "(Landroidx/compose/ui/node/LayoutNode;)V";
    private static final String ON_ATTACH_FUNCTION_NAME = "onAttach";
    private static final String ON_ATTACH_DESCRIPTION = "(Landroidx/compose/ui/node/LayoutNode;)V";
    private static final String ON_DETACH_FUNCTION_NAME = "onDetach";
    private static final String ON_DETACH_DESCRIPTION = "(Landroidx/compose/ui/node/LayoutNode;)V";
    private final String resolvedInstrumentorApi;
    private final ComposeVersion composeVersion;

    public SessionReplayComposeViewSensor(ClassResolver classResolver) {
        this.resolvedInstrumentorApi = ComposeVersion.getInstrumentorApi(classResolver);
        this.composeVersion = ComposeVersion.getVersion(classResolver);
    }

    @Override
    public boolean matchClass(ClassInfo classInfo) {
        return ANDROID_COMPOSE_VIEW_SOURCE.equals(classInfo.getName());
    }

    @Override
    public List<MethodSensor> getSensors() {
        ArrayList<MethodSensor> methodSensorList = new ArrayList<MethodSensor>();
        methodSensorList.add(this.generateOnAttachedToWindowSensor());
        methodSensorList.add(this.generateOnDetachedFromWindowSensor());
        methodSensorList.add(this.generateOnLayoutChangeSensor());
        methodSensorList.add(this.generateOnAttachSensor("com.dynatrace.android.internal.api.compose.InstrumentorComposeApi"));
        methodSensorList.add(this.generateOnDetachSensor("com.dynatrace.android.internal.api.compose.InstrumentorComposeApi"));
        methodSensorList.add(this.generateOnAttachSensor(this.resolvedInstrumentorApi));
        methodSensorList.add(this.generateOnDetachSensor(this.resolvedInstrumentorApi));
        if (this.composeVersion == ComposeVersion.V1_4) {
            methodSensorList.add(this.generateOnRequestMeasureSensor_1_4());
        } else {
            methodSensorList.add(this.generateOnRequestMeasureSensor_1_5());
        }
        return methodSensorList;
    }

    private MethodSensor generateOnLayoutChangeSensor() {
        MethodInfo methodInfo = new MethodInfo(ON_LAYOUT_CHANGE_FUNCTION_NAME, "(Landroidx/compose/ui/node/LayoutNode;)V", 1, null, new ArrayList<String>());
        return new MethodSensorImpl(methodInfo, new StartMethodTransformation(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash(this.resolvedInstrumentorApi), ON_LAYOUT_CHANGE_FUNCTION_NAME, "(Landroidx/compose/ui/layout/LayoutInfo;)V"), ParameterInstructionProvider.withAllParameters("(Landroidx/compose/ui/node/LayoutNode;)V")));
    }

    private MethodSensor generateOnAttachSensor(String instrumentorApi) {
        MethodInfo methodInfo = new MethodInfo(ON_ATTACH_FUNCTION_NAME, "(Landroidx/compose/ui/node/LayoutNode;)V", 1, null, new ArrayList<String>());
        return new MethodSensorImpl(methodInfo, new StartMethodTransformation(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash(instrumentorApi), ON_ATTACH_FUNCTION_NAME, "(Landroidx/compose/ui/layout/LayoutInfo;)V"), ParameterInstructionProvider.withAllParameters("(Landroidx/compose/ui/node/LayoutNode;)V")));
    }

    private MethodSensor generateOnDetachSensor(String instrumentorApi) {
        MethodInfo methodInfo = new MethodInfo(ON_DETACH_FUNCTION_NAME, "(Landroidx/compose/ui/node/LayoutNode;)V", 1, null, new ArrayList<String>());
        return new MethodSensorImpl(methodInfo, new StartMethodTransformation(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash(instrumentorApi), ON_DETACH_FUNCTION_NAME, "(Landroidx/compose/ui/layout/LayoutInfo;)V"), ParameterInstructionProvider.withAllParameters("(Landroidx/compose/ui/node/LayoutNode;)V")));
    }

    private MethodSensor generateOnAttachedToWindowSensor() {
        MethodInfo methodInfo = new MethodInfo("onAttachedToWindow", "()V", 4, null, new ArrayList<String>());
        return new MethodSensorImpl(methodInfo, new StartMethodTransformation(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.internal.api.compose.InstrumentorComposeApi"), "onAttachedToWindow", "(Landroid/view/View;)V"), ParameterInstructionProvider.withThis()));
    }

    private MethodSensor generateOnDetachedFromWindowSensor() {
        MethodInfo methodInfo = new MethodInfo("onDetachedFromWindow", "()V", 4, null, new ArrayList<String>());
        return new MethodSensorImpl(methodInfo, new StartMethodTransformation(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.internal.api.compose.InstrumentorComposeApi"), "onDetachedFromWindow", "(Landroid/view/View;)V"), ParameterInstructionProvider.withThis()));
    }

    private MethodSensor generateOnRequestMeasureSensor_1_4() {
        MethodInfo methodInfo = new MethodInfo("onRequestMeasure", "(Landroidx/compose/ui/node/LayoutNode;ZZ)V", 1, null, new ArrayList<String>());
        return new MethodSensorImpl(methodInfo, new StartMethodTransformation(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.internal.api.compose14.InstrumentorComposeApi"), "onRequestMeasure", "(Landroidx/compose/ui/layout/LayoutInfo;)V"), ParameterInstructionProvider.withAllParameters("(Landroidx/compose/ui/node/LayoutNode;)V")));
    }

    private MethodSensor generateOnRequestMeasureSensor_1_5() {
        MethodInfo methodInfo = new MethodInfo("onRequestMeasure", "(Landroidx/compose/ui/node/LayoutNode;ZZZ)V", 1, null, new ArrayList<String>());
        return new MethodSensorImpl(methodInfo, new StartMethodTransformation(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.internal.api.compose15.InstrumentorComposeApi"), "onRequestMeasure", "(Landroidx/compose/ui/layout/LayoutInfo;)V"), ParameterInstructionProvider.withAllParameters("(Landroidx/compose/ui/node/LayoutNode;)V")));
    }
}

