/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.dsl;

import com.dynatrace.android.instrumentation.filter.ExclusionManager;
import com.dynatrace.tools.android.dsl.DynatraceExtension;
import com.dynatrace.tools.android.dsl.ExcludeOptions;
import com.dynatrace.tools.android.dsl.VariantConfiguration;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VariantConfigurationUtil {
    private VariantConfigurationUtil() {
    }

    private static boolean matchesVariantFilter(VariantConfiguration variantConfiguration, String name) {
        String variantFilter = variantConfiguration.getVariantFilter();
        if (variantFilter == null) {
            return true;
        }
        Pattern pattern = Pattern.compile(variantFilter);
        Matcher matcher = pattern.matcher(name);
        return matcher.find();
    }

    public static Optional<VariantConfiguration> determineVariantConfiguration(DynatraceExtension extension, String variantName) {
        return extension.getOrderedConfigList().stream().filter(variantConfiguration -> VariantConfigurationUtil.matchesVariantFilter(variantConfiguration, variantName)).findFirst();
    }

    public static VariantConfiguration copy(VariantConfiguration variantConfiguration) {
        return new VariantConfiguration(variantConfiguration);
    }

    public static ExclusionManager generateExclusionManager(VariantConfiguration variantConfiguration) {
        ExcludeOptions excludeOptions = variantConfiguration.getExclude();
        return new ExclusionManager(excludeOptions.getClassLevelFilter(), excludeOptions.getMethodLevelFilter());
    }
}

