/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.filter;

import com.dynatrace.android.instrumentation.filter.ClassLevelFilter;
import com.dynatrace.android.instrumentation.filter.PackageExclusionFilter;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class InstrumentableFilterProvider {
    private InstrumentableFilterProvider() {
    }

    public static List<ClassLevelFilter> defaultFilters() {
        ArrayList<ClassLevelFilter> filters = new ArrayList<ClassLevelFilter>();
        filters.add(new PackageExclusionFilter("com.dynatrace.android"));
        filters.add(new PackageExclusionFilter("com.dynatrace.agent"));
        filters.add(new PackageExclusionFilter("com.google.firebase.perf"));
        filters.add(new PackageExclusionFilter("com.google.android.gms.internal.firebase-perf"));
        filters.add(className -> className.endsWith("package-info"));
        filters.add(className -> className.endsWith("module-info"));
        filters.add(className -> className.toLowerCase(Locale.ROOT).startsWith("meta-inf"));
        return filters;
    }

    public static List<ClassLevelFilter> transformerFilters(List<TransformerFactory> factories) {
        ArrayList<ClassLevelFilter> transformers = new ArrayList<ClassLevelFilter>();
        for (TransformerFactory factory : factories) {
            transformers.addAll(factory.excludeClassFiles());
        }
        return transformers;
    }

    public static List<String> mandatoryClasses(List<TransformerFactory> factories) {
        ArrayList<String> transformers = new ArrayList<String>();
        for (TransformerFactory factory : factories) {
            transformers.addAll(factory.mandatoryClasses());
        }
        return transformers;
    }
}

