/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose.replay;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeUi;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import com.dynatrace.android.instrumentation.shared.TransformerUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SessionReplayLazyListSensor
implements SensorGroup<MethodSensor> {
    private static final String LAZY_LIST_SOURCE = "androidx.compose.foundation.lazy.LazyListKt";
    private static final String LAZY_LIST_FUNCTION_NAME = "LazyList";
    private static final String LAZY_LIST_DESCRIPTION = "(Landroidx/compose/ui/Modifier;Landroidx/compose/foundation/lazy/LazyListState;Landroidx/compose/foundation/layout/PaddingValues;ZZLandroidx/compose/foundation/gestures/FlingBehavior;ZILandroidx/compose/ui/Alignment$Horizontal;Landroidx/compose/foundation/layout/Arrangement$Vertical;Landroidx/compose/ui/Alignment$Vertical;Landroidx/compose/foundation/layout/Arrangement$Horizontal;Lkotlin/jvm/functions/Function1;Landroidx/compose/runtime/Composer;III)V";
    private final String tableModifier;

    public SessionReplayLazyListSensor(ClassResolver classResolver) {
        String composePackage = ComposeUi.getVersionPackage(classResolver);
        this.tableModifier = composePackage + "/model/DTTableModifier";
    }

    @Override
    public boolean matchClass(ClassInfo classInfo) {
        return LAZY_LIST_SOURCE.equals(classInfo.getName());
    }

    @Override
    public List<MethodSensor> getSensors() {
        MethodInfo methodInfo = new MethodInfo(LAZY_LIST_FUNCTION_NAME, LAZY_LIST_DESCRIPTION, 25, null, new ArrayList<String>());
        MethodTransformation lazyListTransformation = (methodNode, startParameterIndex) -> TransformerUtils.insertAtMethodStart(methodNode, list -> {
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new TypeInsnNode(187, this.tableModifier));
            list.add((AbstractInsnNode)new InsnNode(89));
            list.add((AbstractInsnNode)new MethodInsnNode(183, this.tableModifier, "<init>", "()V", false));
            list.add((AbstractInsnNode)new MethodInsnNode(185, "androidx/compose/ui/Modifier", "then", "(Landroidx/compose/ui/Modifier;)Landroidx/compose/ui/Modifier;", true));
            list.add((AbstractInsnNode)new VarInsnNode(58, startParameterIndex));
        });
        return Collections.singletonList(new MethodSensorImpl(methodInfo, lazyListTransformation));
    }
}

