/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose.replay;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeUi;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import com.dynatrace.android.instrumentation.shared.TransformerUtils;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SessionReplayLazyStaggeredGridSensor
implements SensorGroup<MethodSensor> {
    private static final String LAZY_STAGGERED_GRID_SOURCE = "androidx.compose.foundation.lazy.staggeredgrid.LazyStaggeredGridKt";
    private static final String LAZY_STAGGERED_GRID_FUNCTION_NAME = "LazyStaggeredGrid-LJWHXA8";
    private static final String LAZY_STAGGERED_GRID_DESCRIPTION = "(Landroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridState;Landroidx/compose/foundation/gestures/Orientation;Lkotlin/jvm/functions/Function2;Landroidx/compose/ui/Modifier;Landroidx/compose/foundation/layout/PaddingValues;ZLandroidx/compose/foundation/gestures/FlingBehavior;ZFFLkotlin/jvm/functions/Function1;Landroidx/compose/runtime/Composer;III)V";
    private static final String LAZY_STAGGERED_GRID_DESCRIPTION_1_6 = "(Landroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridState;Landroidx/compose/foundation/gestures/Orientation;Landroidx/compose/foundation/lazy/staggeredgrid/LazyGridStaggeredGridSlotsProvider;Landroidx/compose/ui/Modifier;Landroidx/compose/foundation/layout/PaddingValues;ZLandroidx/compose/foundation/gestures/FlingBehavior;ZFFLkotlin/jvm/functions/Function1;Landroidx/compose/runtime/Composer;III)V";
    private final String tableModifier;

    public SessionReplayLazyStaggeredGridSensor(ClassResolver classResolver) {
        String composePackage = ComposeUi.getVersionPackage(classResolver);
        this.tableModifier = composePackage + "/model/DTTableModifier";
    }

    @Override
    public boolean matchClass(ClassInfo classInfo) {
        return LAZY_STAGGERED_GRID_SOURCE.equals(classInfo.getName());
    }

    @Override
    public List<MethodSensor> getSensors() {
        return List.of(this.getLazyStaggeredGridSensor(LAZY_STAGGERED_GRID_DESCRIPTION), this.getLazyStaggeredGridSensor(LAZY_STAGGERED_GRID_DESCRIPTION_1_6));
    }

    private MethodSensorImpl getLazyStaggeredGridSensor(String functionDescription) {
        MethodInfo methodInfo = new MethodInfo(LAZY_STAGGERED_GRID_FUNCTION_NAME, functionDescription, 25, null, new ArrayList<String>());
        MethodTransformation lazyGridTransformation = (methodNode, startParameterIndex) -> TransformerUtils.insertAtMethodStart(methodNode, list -> {
            list.add((AbstractInsnNode)new VarInsnNode(25, 3));
            list.add((AbstractInsnNode)new TypeInsnNode(187, this.tableModifier));
            list.add((AbstractInsnNode)new InsnNode(89));
            list.add((AbstractInsnNode)new MethodInsnNode(183, this.tableModifier, "<init>", "()V", false));
            list.add((AbstractInsnNode)new MethodInsnNode(185, "androidx/compose/ui/Modifier", "then", "(Landroidx/compose/ui/Modifier;)Landroidx/compose/ui/Modifier;", true));
            list.add((AbstractInsnNode)new VarInsnNode(58, 3));
        });
        return new MethodSensorImpl(methodInfo, lazyGridTransformation);
    }
}

