/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose.replay;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeUi;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import com.dynatrace.android.instrumentation.shared.TransformerUtils;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SessionReplayScrollableSensor
implements SensorGroup<MethodSensor> {
    private static final String SCROLLABLE_MODIFIER_SOURCE = "androidx.compose.foundation.gestures.ScrollableKt";
    private static final String SCROLLABLE_FUNCTION_NAME = "scrollable";
    private static final String SCROLLABLE_DESCRIPTION = "(Landroidx/compose/ui/Modifier;Landroidx/compose/foundation/gestures/ScrollableState;Landroidx/compose/foundation/gestures/Orientation;Landroidx/compose/foundation/OverscrollEffect;ZZLandroidx/compose/foundation/gestures/FlingBehavior;Landroidx/compose/foundation/interaction/MutableInteractionSource;)Landroidx/compose/ui/Modifier;";
    private static final String SCROLLABLE_DESCRIPTION_1_6 = "(Landroidx/compose/ui/Modifier;Landroidx/compose/foundation/gestures/ScrollableState;Landroidx/compose/foundation/gestures/Orientation;Landroidx/compose/foundation/OverscrollEffect;ZZLandroidx/compose/foundation/gestures/FlingBehavior;Landroidx/compose/foundation/interaction/MutableInteractionSource;Landroidx/compose/foundation/gestures/BringIntoViewSpec;)Landroidx/compose/ui/Modifier;";
    private final String scrollModifier;

    public SessionReplayScrollableSensor(ClassResolver classResolver) {
        String composePackage = ComposeUi.getVersionPackage(classResolver);
        this.scrollModifier = composePackage + "/model/DTScrollModifier";
    }

    @Override
    public boolean matchClass(ClassInfo classInfo) {
        return SCROLLABLE_MODIFIER_SOURCE.equals(classInfo.getName());
    }

    @Override
    public List<MethodSensor> getSensors() {
        return List.of(this.generateScrollableModifierSensor(SCROLLABLE_DESCRIPTION), this.generateScrollableModifierSensor(SCROLLABLE_DESCRIPTION_1_6));
    }

    private MethodSensor generateScrollableModifierSensor(String functionDescription) {
        MethodInfo methodInfo = new MethodInfo(SCROLLABLE_FUNCTION_NAME, functionDescription, 25, null, new ArrayList<String>());
        MethodTransformation scrollableModifierTransformation = (methodNode, startParameterIndex) -> TransformerUtils.insertAtMethodStart(methodNode, list -> {
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new TypeInsnNode(187, this.scrollModifier));
            list.add((AbstractInsnNode)new InsnNode(89));
            list.add((AbstractInsnNode)new MethodInsnNode(183, this.scrollModifier, "<init>", "()V", false));
            list.add((AbstractInsnNode)new MethodInsnNode(185, "androidx/compose/ui/Modifier", "then", "(Landroidx/compose/ui/Modifier;)Landroidx/compose/ui/Modifier;", true));
            list.add((AbstractInsnNode)new VarInsnNode(58, startParameterIndex));
        });
        return new MethodSensorImpl(methodInfo, scrollableModifierTransformation);
    }
}

