/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose.version;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeVersion;

public abstract class ComposeMaterial {
    private static final String ANCHORED_DRAGGABLE_DEFAULTS_1_5 = "androidx.compose.material.AnchoredDraggableDefaults";
    private static final String ANCHORED_DRAG_FINISHED_SIGNAL = "androidx.compose.material.AnchoredDragFinishedSignal";
    private static final String BOTTOM_DRAWER = "androidx.compose.material.DrawerKt$BottomDrawer$2";
    private static final String FUNCTION_2 = "kotlin.jvm.functions.Function2";

    public static ComposeVersion getVersion(ClassResolver classResolver) {
        if (classResolver.resolveClass(ANCHORED_DRAG_FINISHED_SIGNAL).isComplete()) {
            return ComposeMaterial.getBottomDrawerVersion(classResolver);
        }
        if (classResolver.resolveClass(ANCHORED_DRAGGABLE_DEFAULTS_1_5).isComplete()) {
            return ComposeVersion.V1_5;
        }
        return ComposeVersion.V1_4;
    }

    private static ComposeVersion getBottomDrawerVersion(ClassResolver classResolver) {
        ClassInfo bottomDrawerInfo = classResolver.resolveClass(BOTTOM_DRAWER);
        ClassInfo function2Info = classResolver.resolveClass(FUNCTION_2);
        if (bottomDrawerInfo.isComplete() && function2Info.isComplete() && bottomDrawerInfo.getInterfaces().contains(function2Info.getName())) {
            return ComposeVersion.V1_7;
        }
        return ComposeVersion.V1_6;
    }

    public static String getVersionPackage(ClassResolver classResolver) {
        return ComposeVersion.getVersionPackage(ComposeMaterial.getVersion(classResolver));
    }

    public static String getInstrumentorApi(ClassResolver classResolver) {
        return ComposeVersion.getInstrumentorApi(ComposeMaterial.getVersion(classResolver));
    }
}

