/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.sensor.compose.transformation.ComposePagerStateTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.transformation.ComposePagerTransformation;
import com.dynatrace.android.instrumentation.sensor.compose.transformation.ComposePagerTransformation_1_5;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeUi;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeVersion;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.compose.ComposeSubTransformer;
import com.dynatrace.android.instrumentation.transform.compose.ComposeTransformation;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComposePagerTransformFactory
implements TransformerFactory {
    private final boolean useSemantics;
    private static final Logger logger = LoggerFactory.getLogger((String)"ComposePager");

    public ComposePagerTransformFactory(boolean useSemantics) {
        this.useSemantics = useSemantics;
    }

    @Override
    public SubTransformer generateTransformer(ClassResolver classResolver) throws Exception {
        ComposeVersion composeVersion = ComposeUi.getVersion(classResolver);
        ArrayList<ComposeTransformation> factories = new ArrayList<ComposeTransformation>();
        if (composeVersion == ComposeVersion.V1_4) {
            factories.add(new ComposePagerTransformation(this.useSemantics));
        } else if (composeVersion == ComposeVersion.V1_5 || composeVersion == ComposeVersion.V1_6 || composeVersion == ComposeVersion.V1_7) {
            factories.add(new ComposePagerTransformation_1_5(this.useSemantics));
        } else {
            logger.debug("Instrumentation for pager UI components is not supported for this Jetpack Compose version");
        }
        factories.add(new ComposePagerStateTransformation());
        return new ComposeSubTransformer("ComposePagerTransformFactory", factories);
    }
}

