/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import com.dynatrace.android.instrumentation.sensor.agent.InstrumentationFlavor;
import com.dynatrace.tools.android.InstrumentationFlavorParser;
import org.gradle.api.GradleException;
import org.gradle.api.Project;

public class DynatraceGradleProperties {
    private final InstrumentationFlavor instrumentationFlavor;
    private final boolean sessionReplayComposeEnabled;

    private DynatraceGradleProperties(PropertyFactory propertyFactory) {
        this.instrumentationFlavor = propertyFactory.instrumentationFlavor;
        this.sessionReplayComposeEnabled = propertyFactory.sessionReplayComposeEnabled;
    }

    public InstrumentationFlavor getInstrumentationFlavor() {
        return this.instrumentationFlavor;
    }

    public boolean isSessionReplayComposeEnabled() {
        return this.sessionReplayComposeEnabled;
    }

    public String toString() {
        return "DynatraceGradleProperties{instrumentationFlavor=" + this.instrumentationFlavor + ", sessionReplayComposeEnabled=" + this.sessionReplayComposeEnabled + "}";
    }

    public static class PropertyFactory {
        private static final String INSTRUMENTATION_FLAVOR = "dynatrace.instrumentationFlavor";
        private static final String ENABLE_SESSION_REPLAY_COMPOSE_INSTRUMENTATION = "dynatrace.instrumentSessionReplayCompose";
        private InstrumentationFlavor instrumentationFlavor = InstrumentationFlavor.PLAIN;
        private boolean sessionReplayComposeEnabled = false;

        public PropertyFactory withInstrumentationFlavor(InstrumentationFlavor instrumentationFlavor) {
            if (instrumentationFlavor == null) {
                instrumentationFlavor = InstrumentationFlavor.PLAIN;
            }
            this.instrumentationFlavor = instrumentationFlavor;
            return this;
        }

        public PropertyFactory withSessionReplayComposeEnabled(boolean sessionReplayComposeEnabled) {
            this.sessionReplayComposeEnabled = sessionReplayComposeEnabled;
            return this;
        }

        public PropertyFactory fromProject(Project project) {
            try {
                this.withInstrumentationFlavor(new InstrumentationFlavorParser().parse((String)project.findProperty(INSTRUMENTATION_FLAVOR)));
            }
            catch (IllegalArgumentException e) {
                throw new GradleException("Can't parse value from property 'dynatrace.instrumentationFlavor'", (Throwable)e);
            }
            this.withSessionReplayComposeEnabled(Boolean.parseBoolean((String)project.findProperty(ENABLE_SESSION_REPLAY_COMPOSE_INSTRUMENTATION)));
            return this;
        }

        public DynatraceGradleProperties build() {
            return new DynatraceGradleProperties(this);
        }
    }
}

