/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose.replay.sensor;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeUi;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.sensor.method.StartMethodTransformation;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SessionReplayLegacyTextFieldStateSensor
implements SensorGroup<MethodSensor> {
    private static final String TEXT_FIELD_STATE_SOURCE = "androidx.compose.foundation.text.LegacyTextFieldState";
    private static final String TEXT_FIELD_STATE_FUNCTION_NAME = "setHasFocus";
    private static final String TEXT_FIELD_STATE_DESCRIPTION = "(Z)V";
    private final String instrumentorApi;

    public SessionReplayLegacyTextFieldStateSensor(ClassResolver classResolver) {
        this.instrumentorApi = ComposeUi.getInstrumentorApi(classResolver);
    }

    @Override
    public boolean matchClass(ClassInfo classInfo) {
        return TEXT_FIELD_STATE_SOURCE.equals(classInfo.getName());
    }

    @Override
    public List<MethodSensor> getSensors() {
        MethodInfo methodInfo = new MethodInfo(TEXT_FIELD_STATE_FUNCTION_NAME, TEXT_FIELD_STATE_DESCRIPTION, 17, null, new ArrayList<String>());
        ParameterInstructionProvider provider = (instructions, startParameterIndex) -> {
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new MethodInsnNode(182, "androidx/compose/foundation/text/LegacyTextFieldState", "getLayoutCoordinates", "()Landroidx/compose/ui/layout/LayoutCoordinates;", false));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new MethodInsnNode(182, "androidx/compose/foundation/text/LegacyTextFieldState", "getUntransformedText", "()Landroidx/compose/ui/text/AnnotatedString;", false));
            instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
        };
        MethodSensorImpl transformation = new MethodSensorImpl(methodInfo, new StartMethodTransformation(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash(this.instrumentorApi), "onTextFieldStateFocus", "(Landroidx/compose/ui/layout/LayoutCoordinates;Landroidx/compose/ui/text/AnnotatedString;Z)V"), provider));
        return Collections.singletonList(new MethodSensorImpl(methodInfo, transformation));
    }
}

