/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose.replay.sensor.material3;

import com.dynatrace.android.instrumentation.ClassInfo;
import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeMaterial3;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeMaterial3Version;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeUi;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.sensor.method.StartMethodTransformation;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;
import java.util.List;

public class SessionReplayModalBottomSheetSensor
implements SensorGroup<MethodSensor> {
    private static final String MODAL_BOTTOM_SHEET_SOURCE = "androidx.compose.material3.ModalBottomSheet_androidKt";
    private static final String MODAL_BOTTOM_SHEET_FUNCTION_NAME = "ModalBottomSheet-dYc4hso";
    private static final String MODAL_BOTTOM_SHEET_DESCRIPTION = "(Lkotlin/jvm/functions/Function0;Landroidx/compose/ui/Modifier;Landroidx/compose/material3/SheetState;FLandroidx/compose/ui/graphics/Shape;JJFJLkotlin/jvm/functions/Function2;Landroidx/compose/foundation/layout/WindowInsets;Landroidx/compose/material3/ModalBottomSheetProperties;Lkotlin/jvm/functions/Function3;Landroidx/compose/runtime/Composer;III)V";
    private static final String MODAL_BOTTOM_SHEET_FUNCTION_NAME2 = "ModalBottomSheet-EP0qOeE";
    private static final String MODAL_BOTTOM_SHEET_DESCRIPTION2 = "(Lkotlin/jvm/functions/Function0;Landroidx/compose/ui/Modifier;Landroidx/compose/material3/SheetState;Landroidx/compose/ui/graphics/Shape;JJFJLkotlin/jvm/functions/Function2;Landroidx/compose/foundation/layout/WindowInsets;Lkotlin/jvm/functions/Function3;Landroidx/compose/runtime/Composer;III)V";
    private final String instrumentorApi;
    private final ClassResolver classResolver;

    public SessionReplayModalBottomSheetSensor(ClassResolver classResolver) {
        this.classResolver = classResolver;
        this.instrumentorApi = ComposeUi.getInstrumentorApi(classResolver);
    }

    @Override
    public boolean matchClass(ClassInfo classInfo) {
        return MODAL_BOTTOM_SHEET_SOURCE.equals(classInfo.getName());
    }

    @Override
    public List<MethodSensor> getSensors() {
        return List.of(this.getModalBottomSheetSensor());
    }

    private MethodSensor getModalBottomSheetSensor() {
        MethodInfo methodInfo = this.getBottomSheetMethodInfo();
        return new MethodSensorImpl(methodInfo, new StartMethodTransformation(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash(this.instrumentorApi), "onSheetStateChange", "(Landroidx/compose/material3/SheetState;)V"), ParameterInstructionProvider.withCustomParameter(25, 2)));
    }

    private MethodInfo getBottomSheetMethodInfo() {
        ComposeMaterial3Version composeMaterial3Version = ComposeMaterial3.getVersion(this.classResolver);
        if (composeMaterial3Version == ComposeMaterial3Version.V1_3) {
            return new MethodInfo(MODAL_BOTTOM_SHEET_FUNCTION_NAME, MODAL_BOTTOM_SHEET_DESCRIPTION, 25, null, new ArrayList<String>());
        }
        return new MethodInfo(MODAL_BOTTOM_SHEET_FUNCTION_NAME2, MODAL_BOTTOM_SHEET_DESCRIPTION2, 25, null, new ArrayList<String>());
    }
}

