/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose.replay.transformation.material3;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeMaterial3;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeMaterial3Version;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeUi;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ComposeReplaySwitchTransformation
implements MethodTransformation {
    private final String composePackage;
    private final ComposeMaterial3Version composeMaterial3Version;

    public ComposeReplaySwitchTransformation(ClassResolver classResolver) {
        this.composePackage = ComposeUi.getVersionPackage(classResolver);
        this.composeMaterial3Version = ComposeMaterial3.getVersion(classResolver);
    }

    @Override
    public void transformMethod(MethodNode methodNode, int startParameterIndex) {
        int delta = this.composeMaterial3Version == ComposeMaterial3Version.V1_3 ? 3 : 1;
        this.addModifierInstructions(methodNode, delta);
    }

    private void addModifierInstructions(MethodNode methodNode, int delta) {
        InsnList instructions = methodNode.instructions;
        for (int insIndex = 0; insIndex < instructions.size() - delta; ++insIndex) {
            AbstractInsnNode insNode = instructions.get(insIndex);
            AbstractInsnNode nextInsNode = instructions.get(insIndex + delta);
            if (!this.isGetStaticModifierCompanionNode(insNode) || !this.isStoreNode(nextInsNode)) continue;
            InsnList list = new InsnList();
            this.addCompoundModifierModifier(list);
            instructions.insert(insNode, list);
        }
    }

    private boolean isStoreNode(AbstractInsnNode insNode) {
        return insNode instanceof VarInsnNode && insNode.getOpcode() == 58;
    }

    private boolean isGetStaticModifierCompanionNode(AbstractInsnNode insNode) {
        return insNode instanceof FieldInsnNode && insNode.getOpcode() == 178 && ((FieldInsnNode)insNode).owner.equals("androidx/compose/ui/Modifier") && ((FieldInsnNode)insNode).name.equals("Companion");
    }

    private void addCompoundModifierModifier(InsnList list) {
        String dtCompoundModifier = this.composePackage + "/model/DTCompoundModifier";
        list.add((AbstractInsnNode)new TypeInsnNode(187, dtCompoundModifier));
        list.add((AbstractInsnNode)new InsnNode(89));
        list.add((AbstractInsnNode)new LdcInsnNode((Object)2));
        list.add((AbstractInsnNode)new LdcInsnNode((Object)100));
        list.add((AbstractInsnNode)new MethodInsnNode(183, dtCompoundModifier, "<init>", "(II)V", false));
        list.add((AbstractInsnNode)new MethodInsnNode(185, "androidx/compose/ui/Modifier", "then", "(Landroidx/compose/ui/Modifier;)Landroidx/compose/ui/Modifier;", true));
    }
}

