/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose.transformation;

import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeUiVersion;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ComposeCheckboxTransformation
implements MethodTransformation {
    private final String instrumentedClassInstruction;
    private final String checkBoxCallback;

    public ComposeCheckboxTransformation(ComposeUiVersion composeUiVersion) {
        if (composeUiVersion == ComposeUiVersion.V1_7) {
            this.instrumentedClassInstruction = "androidx/compose/material/CheckboxKt$Checkbox$1$1";
            this.checkBoxCallback = "com/dynatrace/android/compose/CheckBoxComposeCallback_1_7";
        } else {
            this.instrumentedClassInstruction = "androidx/compose/material/CheckboxKt$Checkbox$2$1";
            this.checkBoxCallback = "com/dynatrace/android/compose/WrappingToggleableComposeCallback";
        }
    }

    @Override
    public void transformMethod(MethodNode methodNode, int startParameterIndex) {
        InsnList instructions = methodNode.instructions;
        for (AbstractInsnNode insnNode : instructions) {
            InsnList list = new InsnList();
            if (insnNode instanceof TypeInsnNode && insnNode.getOpcode() == 187 && ((TypeInsnNode)insnNode).desc.equals(this.instrumentedClassInstruction)) {
                list.add((AbstractInsnNode)new TypeInsnNode(187, this.checkBoxCallback));
                list.add((AbstractInsnNode)new InsnNode(89));
                instructions.insertBefore(insnNode, list);
            }
            if (!(insnNode instanceof MethodInsnNode) || insnNode.getOpcode() != 183 || !((MethodInsnNode)insnNode).name.equals("<init>") || !((MethodInsnNode)insnNode).owner.equals(this.instrumentedClassInstruction)) continue;
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(21, 0));
            list.add((AbstractInsnNode)new MethodInsnNode(183, this.checkBoxCallback, "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Z)V"));
            instructions.insert(insnNode, list);
        }
    }
}

