/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InsertAfterInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.InsertBeforeInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.shared.TransformerUtils;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;
import java.util.function.Function;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.VarInsnNode;

public class HybridAppTransformerFactory
implements TransformerFactory {
    private static final String COOKIE_MANAGER = "android.webkit.CookieManager";
    private static final String WEB_VIEW = "android.webkit.WebView";

    @Override
    public SubTransformer generateTransformer(ClassResolver classResolver) throws Exception {
        ArrayList<SensorGroup<InstructionSensor>> instructionSensors = new ArrayList<SensorGroup<InstructionSensor>>();
        instructionSensors.add(this.generateCookieManagerSensors(classResolver));
        instructionSensors.add(this.generateWebViewSensors(classResolver));
        return new DefaultSubTransformer("HybridAppTransformer", instructionSensors, new ArrayList<SensorGroup<MethodSensor>>(), classResolver);
    }

    private SensorGroup<InstructionSensor> generateCookieManagerSensors(ClassResolver classResolver) {
        TransformerUtils.InstructionFactory factory = instructions -> instructions.add((AbstractInsnNode)Utils.generateMethodInstructionNode(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.agent.Dynatrace"), "restoreCookies", "()V")));
        return new SensorGroupImpl<InstructionSensor>(classResolver.resolveClass(COOKIE_MANAGER), new InsertAfterInstructionSensor(MethodInstruction.createPublicMethodInstruction(Utils.dotToSlash(COOKIE_MANAGER), "removeAllCookie", "()V"), factory), new InsertAfterInstructionSensor(MethodInstruction.createPublicMethodInstruction(Utils.dotToSlash(COOKIE_MANAGER), "removeAllCookies", "(Landroid/webkit/ValueCallback;)V"), factory), new InsertAfterInstructionSensor(MethodInstruction.createPublicMethodInstruction(Utils.dotToSlash(COOKIE_MANAGER), "removeSessionCookie", "()V"), factory), new InsertAfterInstructionSensor(MethodInstruction.createPublicMethodInstruction(Utils.dotToSlash(COOKIE_MANAGER), "removeSessionCookies", "(Landroid/webkit/ValueCallback;)V"), factory));
    }

    private SensorGroup<InstructionSensor> generateWebViewSensors(ClassResolver classResolver) {
        Function<Integer, InsnList> transformer = startIndex -> {
            InsnList instructions = new InsnList();
            instructions.add((AbstractInsnNode)new VarInsnNode(25, startIndex.intValue()));
            instructions.add((AbstractInsnNode)Utils.generateMethodInstructionNode(MethodInstruction.createStaticMethodInstruction(Utils.dotToSlash("com.dynatrace.android.agent.Dynatrace"), "instrumentWebView", "(Landroid/webkit/WebView;)V")));
            return instructions;
        };
        InsertBeforeInstructionSensor sensorLoadUrlOnlyString = new InsertBeforeInstructionSensor(MethodInstruction.createPublicMethodInstruction(Utils.dotToSlash(WEB_VIEW), "loadUrl", "(Ljava/lang/String;)V"), transformer);
        InsertBeforeInstructionSensor sensorLoadUrlWithMap = new InsertBeforeInstructionSensor(MethodInstruction.createPublicMethodInstruction(Utils.dotToSlash(WEB_VIEW), "loadUrl", "(Ljava/lang/String;Ljava/util/Map;)V"), transformer);
        return new SensorGroupImpl<InstructionSensor>(classResolver.resolveClass(WEB_VIEW), sensorLoadUrlOnlyString, sensorLoadUrlWithMap);
    }
}

